/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.auth;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import org.apache.flume.auth.PrivilegedExecutor;
import org.apache.flume.auth.SecurityException;
import org.apache.hadoop.security.UserGroupInformation;

class UGIExecutor
implements PrivilegedExecutor {
    private UserGroupInformation ugi;
    private static final long MIN_TIME_BEFORE_RELOGIN = 300000L;
    private volatile long lastReloginAttempt = 0L;

    UGIExecutor(UserGroupInformation ugi) {
        this.ugi = ugi;
    }

    @Override
    public <T> T execute(PrivilegedAction<T> action) {
        this.ensureValidAuth();
        return (T)this.ugi.doAs(action);
    }

    @Override
    public <T> T execute(PrivilegedExceptionAction<T> action) throws Exception {
        this.ensureValidAuth();
        try {
            return (T)this.ugi.doAs(action);
        }
        catch (IOException ex) {
            throw new SecurityException("Privileged action failed", ex);
        }
        catch (InterruptedException ex) {
            Thread.interrupted();
            throw new SecurityException(ex);
        }
    }

    private void ensureValidAuth() {
        this.reloginUGI(this.ugi);
        if (this.ugi.getAuthenticationMethod().equals((Object)UserGroupInformation.AuthenticationMethod.PROXY)) {
            this.reloginUGI(this.ugi.getRealUser());
        }
    }

    private void reloginUGI(UserGroupInformation ugi) {
        try {
            if (ugi.hasKerberosCredentials()) {
                long now = System.currentTimeMillis();
                if (now - this.lastReloginAttempt < 300000L) {
                    return;
                }
                this.lastReloginAttempt = now;
                ugi.checkTGTAndReloginFromKeytab();
            }
        }
        catch (IOException e) {
            throw new SecurityException("Error trying to relogin from keytab for user " + ugi.getUserName(), e);
        }
    }

    @VisibleForTesting
    String getUserName() {
        if (this.ugi != null) {
            return this.ugi.getUserName();
        }
        return null;
    }
}

