/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.assembler.ir.attributes;

import com.strobel.assembler.metadata.TypeReference;
import com.strobel.core.VerifyArgument;

public final class LocalVariableTableEntry {
    private final int _index;
    private final String _name;
    private final TypeReference _type;
    private final String _originalSignature;
    private final int _scopeOffset;
    private final int _scopeLength;
    private final boolean _isBadType;

    public LocalVariableTableEntry(int index, String name, TypeReference type, String originalSignature, int scopeOffset, int scopeLength, boolean isBadType) {
        this._index = VerifyArgument.isNonNegative((int)index, (String)"index");
        this._name = (String)VerifyArgument.notNull((Object)name, (String)"name");
        this._type = (TypeReference)VerifyArgument.notNull((Object)type, (String)"type");
        this._originalSignature = (String)VerifyArgument.notNull((Object)originalSignature, (String)"originalSignature");
        this._scopeOffset = VerifyArgument.isNonNegative((int)scopeOffset, (String)"scopeOffset");
        this._scopeLength = VerifyArgument.isNonNegative((int)scopeLength, (String)"scopeLength");
        this._isBadType = isBadType;
    }

    public int getIndex() {
        return this._index;
    }

    public String getName() {
        return this._name;
    }

    public TypeReference getType() {
        return this._type;
    }

    public int getScopeOffset() {
        return this._scopeOffset;
    }

    public int getScopeLength() {
        return this._scopeLength;
    }

    public String getOriginalSignature() {
        return this._originalSignature;
    }

    public boolean isBadType() {
        return this._isBadType;
    }

    public String toString() {
        return "LocalVariableTableEntry{Index=" + this._index + ", Name='" + this._name + '\'' + ", Type=" + this._type + ", OriginalSignature=" + this._originalSignature + ", ScopeOffset=" + this._scopeOffset + ", ScopeLength=" + this._scopeLength + ", IsBadType=" + this._isBadType + '}';
    }
}

