/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.patterns;

import com.strobel.core.StringUtilities;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.AstType;
import com.strobel.decompiler.languages.java.ast.BlockStatement;
import com.strobel.decompiler.languages.java.ast.CatchClause;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.ParameterDeclaration;
import com.strobel.decompiler.languages.java.ast.Statement;
import com.strobel.decompiler.languages.java.ast.VariableInitializer;
import com.strobel.decompiler.patterns.BacktrackingInfo;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;
import com.strobel.decompiler.patterns.PossibleMatch;
import com.strobel.decompiler.patterns.Role;
import java.util.Stack;

public abstract class Pattern
implements INode {
    public static final String ANY_STRING = "$any$";

    public static boolean matchString(String pattern, String text) {
        return ANY_STRING.equals(pattern) || StringUtilities.equals((String)pattern, (String)text);
    }

    public final AstNode toNode() {
        return AstNode.forPattern(this);
    }

    public final Expression toExpression() {
        return Expression.forPattern(this);
    }

    public final Statement toStatement() {
        return Statement.forPattern(this);
    }

    public final BlockStatement toBlockStatement() {
        return BlockStatement.forPattern(this);
    }

    public final CatchClause toCatchClause() {
        return CatchClause.forPattern(this);
    }

    public final VariableInitializer toVariableInitializer() {
        return VariableInitializer.forPattern(this);
    }

    public final ParameterDeclaration toParameterDeclaration() {
        return ParameterDeclaration.forPattern(this);
    }

    public final AstType toType() {
        return AstType.forPattern(this);
    }

    @Override
    public boolean isNull() {
        return false;
    }

    public Role getRole() {
        return null;
    }

    @Override
    public INode getFirstChild() {
        return null;
    }

    @Override
    public INode getNextSibling() {
        return null;
    }

    @Override
    public abstract boolean matches(INode var1, Match var2);

    @Override
    public boolean matchesCollection(Role role, INode position, Match match, BacktrackingInfo backtrackingInfo) {
        return this.matches(position, match);
    }

    @Override
    public final Match match(INode other) {
        Match match = Match.createNew();
        return this.matches(other, match) ? match : Match.failure();
    }

    @Override
    public final boolean matches(INode other) {
        return this.matches(other, Match.createNew());
    }

    public static boolean matchesCollection(Role<?> role, INode firstPatternChild, INode firstOtherChild, Match match) {
        BacktrackingInfo backtrackingInfo = new BacktrackingInfo();
        Stack<INode> patternStack = new Stack<INode>();
        Stack<PossibleMatch> stack = backtrackingInfo.stack;
        patternStack.push(firstPatternChild);
        stack.push(new PossibleMatch(firstOtherChild, match.getCheckPoint()));
        while (!stack.isEmpty()) {
            INode current2 = stack.peek().nextOther;
            match.restoreCheckPoint(stack.pop().checkPoint);
            boolean success = true;
            for (INode current1 = (INode)patternStack.pop(); current1 != null && success; current1 = current1.getNextSibling()) {
                while (current1 != null && current1.getRole() != role) {
                    current1 = current1.getNextSibling();
                }
                while (current2 != null && current2.getRole() != role) {
                    current2 = current2.getNextSibling();
                }
                if (current1 == null) break;
                assert (stack.size() == patternStack.size());
                success = current1.matchesCollection(role, current2, match, backtrackingInfo);
                assert (stack.size() >= patternStack.size());
                while (stack.size() > patternStack.size()) {
                    patternStack.push(current1.getNextSibling());
                }
                if (current2 == null) continue;
                current2 = current2.getNextSibling();
            }
            while (current2 != null && current2.getRole() != role) {
                current2 = current2.getNextSibling();
            }
            if (!success || current2 != null) continue;
            return true;
        }
        return false;
    }
}

