/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.appassembler;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.installer.ArtifactInstallationException;
import org.apache.maven.artifact.installer.ArtifactInstaller;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.appassembler.AbstractAppAssemblerMojo;
import org.codehaus.mojo.appassembler.Program;
import org.codehaus.mojo.appassembler.daemon.DaemonGenerationRequest;
import org.codehaus.mojo.appassembler.daemon.DaemonGeneratorException;
import org.codehaus.mojo.appassembler.daemon.DaemonGeneratorService;
import org.codehaus.mojo.appassembler.daemon.script.Platform;
import org.codehaus.mojo.appassembler.model.Classpath;
import org.codehaus.mojo.appassembler.model.Daemon;
import org.codehaus.mojo.appassembler.model.Dependency;
import org.codehaus.mojo.appassembler.model.Directory;
import org.codehaus.mojo.appassembler.model.JvmSettings;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public class AssembleMojo
extends AbstractAppAssemblerMojo {
    private File assembleDirectory;
    private Set programs;
    private String binFolder;
    private String configurationDirectory;
    private File configurationSourceDirectory;
    private boolean copyConfigurationDirectory;
    private boolean includeConfigurationDirectoryInClasspath;
    private String repositoryLayout;
    private String extraJvmArguments;
    private Set platforms;
    private String environmentSetupFileName;
    private boolean generateRepository;
    private String repositoryName;
    private boolean projectArtifactFirstInClassPath;
    private boolean useAllDependencies;
    private boolean useAsterikClassPath;
    protected Map binFileExtensions;
    private MavenProject mavenProject;
    private List artifacts;
    private Artifact projectArtifact;
    private ArtifactRepository localRepository;
    private boolean showConsoleWindow;
    private File licenseHeaderFile;
    private ArtifactRepositoryFactory artifactRepositoryFactory;
    private ArtifactInstaller artifactInstaller;
    private DaemonGeneratorService daemonGeneratorService;
    private Map availableRepositoryLayouts;
    private static final Set VALID_PLATFORMS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("unix", "windows")));

    private void validate(Set defaultPlatforms) throws MojoFailureException, MojoExecutionException {
        ArrayList<String> programNames = new ArrayList<String>();
        Iterator i = this.programs.iterator();
        while (i.hasNext()) {
            Program program = (Program)i.next();
            if (program.getMainClass() == null || program.getMainClass().trim().equals("")) {
                throw new MojoFailureException("Missing main class in Program configuration");
            }
            if (programNames.contains(program.getName())) {
                throw new MojoFailureException("The program name: " + program.getName() + " exists more than once!");
            }
            programNames.add(program.getName());
            program.setPlatforms(this.validatePlatforms(program.getPlatforms(), defaultPlatforms));
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        Artifact artifact;
        Iterator it;
        Set defaultPlatforms = this.validatePlatforms(this.platforms, VALID_PLATFORMS);
        this.validate(defaultPlatforms);
        if (this.isUseAsterikClassPath() && !this.repositoryLayout.equalsIgnoreCase("flat")) {
            throw new MojoExecutionException("The useAsterikClassPath works only in combination with repositoryLayout flat.");
        }
        this.setBinFileExtensions();
        ArtifactRepositoryLayout artifactRepositoryLayout = (ArtifactRepositoryLayout)this.availableRepositoryLayouts.get(this.repositoryLayout);
        if (artifactRepositoryLayout == null) {
            throw new MojoFailureException("Unknown repository layout '" + this.repositoryLayout + "'.");
        }
        if (this.isUseAllDependencies()) {
            Set dependencyArtifacts = this.mavenProject.getDependencyArtifacts();
            this.artifacts = new ArrayList();
            it = dependencyArtifacts.iterator();
            while (it.hasNext()) {
                artifact = (Artifact)it.next();
                this.artifacts.add(artifact);
            }
        }
        if (this.generateRepository) {
            ArtifactRepository artifactRepository = this.artifactRepositoryFactory.createDeploymentArtifactRepository("appassembler", "file://" + this.assembleDirectory.getAbsolutePath() + "/" + this.repositoryName, artifactRepositoryLayout, false);
            it = this.artifacts.iterator();
            while (it.hasNext()) {
                artifact = (Artifact)it.next();
                this.installArtifact(artifactRepository, artifact);
            }
            this.installArtifact(artifactRepository, this.projectArtifact);
        }
        this.setUpWorkingArea();
        Iterator it2 = this.programs.iterator();
        while (it2.hasNext()) {
            Program program = (Program)it2.next();
            Set validatedPlatforms = this.validatePlatforms(program.getPlatforms(), defaultPlatforms);
            Iterator platformIt = validatedPlatforms.iterator();
            while (platformIt.hasNext()) {
                String platform = (String)platformIt.next();
                Daemon daemon = this.programToDaemon(program, artifactRepositoryLayout);
                DaemonGenerationRequest request = new DaemonGenerationRequest(daemon, this.mavenProject, this.localRepository, this.assembleDirectory, this.binFolder);
                request.setStubDaemon(request.getDaemon());
                request.setPlatform(platform);
                try {
                    this.daemonGeneratorService.generateDaemon(request);
                }
                catch (DaemonGeneratorException e) {
                    throw new MojoExecutionException("Error while generating script for the program '" + program.getName() + "' for the platform '" + platform + "': " + e.getMessage(), (Exception)e);
                }
            }
        }
        if (this.copyConfigurationDirectory) {
            this.copyConfigurationDirectory();
        }
    }

    private Daemon programToDaemon(Program program, ArtifactRepositoryLayout artifactRepositoryLayout) {
        Daemon daemon = new Daemon();
        daemon.setId(program.getName());
        daemon.setMainClass(program.getMainClass());
        daemon.setShowConsoleWindow(this.showConsoleWindow);
        daemon.setCommandLineArguments(program.getCommandLineArguments());
        if (program.getLicenseHeaderFile() != null) {
            this.getLog().debug((CharSequence)("Using the program specific license header. :" + program.getLicenseHeaderFile()));
            daemon.setLicenseHeaderFile(program.getLicenseHeaderFile().getPath());
        } else {
            this.getLog().debug((CharSequence)("Using the global defined license header. :" + this.licenseHeaderFile));
            if (this.licenseHeaderFile != null) {
                daemon.setLicenseHeaderFile(this.licenseHeaderFile.getAbsolutePath());
            } else {
                daemon.setLicenseHeaderFile(null);
            }
        }
        ArrayList<Directory> directories = new ArrayList<Directory>();
        if (this.includeConfigurationDirectoryInClasspath) {
            Directory directory = new Directory();
            directory.setRelativePath(this.configurationDirectory);
            directories.add(directory);
        }
        if (daemon.getClasspath() == null) {
            daemon.setClasspath(new Classpath());
        }
        daemon.getClasspath().setDirectories(directories);
        daemon.setRepositoryName(this.repositoryName);
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        if (this.isUseAsterikClassPath()) {
            Dependency dependency = new Dependency();
            dependency.setGroupId("");
            dependency.setArtifactId("");
            dependency.setVersion("");
            dependency.setRelativePath("*");
            dependencies.add(dependency);
        } else {
            ArrayList<Artifact> classPathArtifacts = new ArrayList<Artifact>();
            if (this.isProjectArtifactFirstInClassPath()) {
                classPathArtifacts.add(this.projectArtifact);
                classPathArtifacts.addAll(this.artifacts);
            } else {
                classPathArtifacts.addAll(this.artifacts);
                classPathArtifacts.add(this.projectArtifact);
            }
            Iterator it = classPathArtifacts.iterator();
            while (it.hasNext()) {
                Artifact artifact = (Artifact)it.next();
                Dependency dependency = new Dependency();
                dependency.setGroupId(artifact.getGroupId());
                dependency.setArtifactId(artifact.getArtifactId());
                dependency.setVersion(artifact.getVersion());
                dependency.setRelativePath(artifactRepositoryLayout.pathOf(artifact));
                dependencies.add(dependency);
            }
        }
        daemon.getClasspath().setDependencies(dependencies);
        daemon.setJvmSettings(this.convertToJvmSettingsWithDefaultHandling(program));
        daemon.setEnvironmentSetupFileName(this.environmentSetupFileName);
        return daemon;
    }

    private JvmSettings convertToJvmSettingsWithDefaultHandling(Program program) {
        JvmSettings jvmSettings = new JvmSettings();
        if (program.getJvmSettings() != null) {
            jvmSettings = program.getJvmSettings();
        } else if (StringUtils.isNotBlank((String)this.extraJvmArguments)) {
            jvmSettings.setExtraArguments(AssembleMojo.parseTokens(this.extraJvmArguments));
        }
        return jvmSettings;
    }

    private void installArtifact(ArtifactRepository artifactRepository, Artifact artifact) throws MojoExecutionException {
        try {
            artifact.isSnapshot();
            if (artifact.getFile() != null) {
                this.getLog().debug((CharSequence)("installArtifact: scope:" + artifact.getScope() + " id:" + artifact.getId()));
                this.artifactInstaller.install(artifact.getFile(), artifact, artifactRepository);
            }
        }
        catch (ArtifactInstallationException e) {
            throw new MojoExecutionException("Failed to copy artifact.", (Exception)((Object)e));
        }
    }

    private void setUpWorkingArea() throws MojoFailureException {
        boolean success;
        File binDir = new File(this.assembleDirectory.getAbsolutePath(), this.binFolder.toString());
        if (!binDir.exists() && !(success = binDir.mkdirs())) {
            throw new MojoFailureException("Failed to create directory for bin files.");
        }
    }

    private void copyConfigurationDirectory() throws MojoFailureException {
        if (!this.configurationSourceDirectory.exists()) {
            throw new MojoFailureException("The source directory for configuration files does not exist: " + this.configurationSourceDirectory.getAbsolutePath());
        }
        File configurationTargetDirectory = new File(this.assembleDirectory.getAbsolutePath(), this.configurationDirectory);
        if (!configurationTargetDirectory.exists()) {
            boolean success = configurationTargetDirectory.mkdirs();
            if (!success) {
                throw new MojoFailureException("Failed to create the target directory for configuration files: " + configurationTargetDirectory.getAbsolutePath());
            }
            try {
                this.getLog().debug((CharSequence)("Will try to copy configuration files from " + this.configurationSourceDirectory.getAbsolutePath() + " to " + configurationTargetDirectory.getAbsolutePath()));
                FileUtils.copyDirectory((File)this.configurationSourceDirectory, (File)configurationTargetDirectory, null, (String)this.getDefaultExcludesAsCommaSeparatedString());
            }
            catch (IOException e) {
                throw new MojoFailureException("Failed to copy the configuration files.");
            }
        }
    }

    private String getDefaultExcludesAsCommaSeparatedString() {
        StringBuffer defaultExcludes = new StringBuffer();
        List defaultExcludesAsList = FileUtils.getDefaultExcludesAsList();
        Iterator iterator = defaultExcludesAsList.iterator();
        while (iterator.hasNext()) {
            String exclude = (String)iterator.next();
            defaultExcludes.append(exclude);
            if (!iterator.hasNext()) continue;
            defaultExcludes.append(",");
        }
        return defaultExcludes.toString();
    }

    private Set validatePlatforms(Set platformsToValidate, Set defaultPlatforms) throws MojoFailureException {
        if (platformsToValidate == null) {
            return defaultPlatforms;
        }
        if (platformsToValidate.size() == 1 && platformsToValidate.iterator().next().equals("all")) {
            return VALID_PLATFORMS;
        }
        if (!VALID_PLATFORMS.containsAll(platformsToValidate)) {
            throw new MojoFailureException("Non-valid default platform declared, supported types are: " + VALID_PLATFORMS);
        }
        return platformsToValidate;
    }

    public static List parseTokens(String arg) {
        ArrayList<String> extraJvmArguments = new ArrayList<String>();
        if (StringUtils.isEmpty((String)arg)) {
            return extraJvmArguments;
        }
        StringTokenizer tokenizer = new StringTokenizer(arg);
        String argument = null;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (argument != null) {
                if (token.length() == 0) continue;
                int length = token.length();
                if (token.charAt(length - 1) == '\"') {
                    extraJvmArguments.add(argument + " " + token.substring(0, length - 1));
                    argument = null;
                    continue;
                }
                argument = argument + " " + token;
                continue;
            }
            if (token.charAt(0) == '\"') {
                argument = token.substring(1);
                continue;
            }
            extraJvmArguments.add(token);
        }
        return extraJvmArguments;
    }

    public void setAvailableRepositoryLayouts(Map availableRepositoryLayouts) {
        this.availableRepositoryLayouts = availableRepositoryLayouts;
    }

    private void setBinFileExtensions() throws MojoFailureException {
        if (this.binFileExtensions != null) {
            Set keySet = this.binFileExtensions.keySet();
            Iterator iterator = keySet.iterator();
            while (iterator.hasNext()) {
                String platformName = (String)iterator.next();
                if (!VALID_PLATFORMS.contains(platformName)) {
                    this.getLog().warn((CharSequence)("Bin file extension configured for a non-valid platform (" + platformName + "), supported platforms are: " + VALID_PLATFORMS));
                    continue;
                }
                try {
                    Platform platform = Platform.getInstance(platformName);
                    platform.setBinFileExtension((String)this.binFileExtensions.get(platformName));
                }
                catch (DaemonGeneratorException e) {
                    this.getLog().warn((CharSequence)("Unable to set the bin file extension for " + platformName), (Throwable)e);
                }
            }
        }
    }

    public boolean isProjectArtifactFirstInClassPath() {
        return this.projectArtifactFirstInClassPath;
    }

    public void setProjectArtifactFirstInClassPath(boolean projectArtifactFirstInClassPath) {
        this.projectArtifactFirstInClassPath = projectArtifactFirstInClassPath;
    }

    public boolean isUseAllDependencies() {
        return this.useAllDependencies;
    }

    public void setUseAllDependencies(boolean useAllDependencies) {
        this.useAllDependencies = useAllDependencies;
    }

    public boolean isUseAsterikClassPath() {
        return this.useAsterikClassPath;
    }

    public void setUseAsterikClassPath(boolean useAsterikClassPath) {
        this.useAsterikClassPath = useAsterikClassPath;
    }
}

