/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.identifier;

import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.rdbms.adapter.DatastoreAdapter;
import org.datanucleus.store.rdbms.identifier.AbstractIdentifierFactory;
import org.datanucleus.store.rdbms.identifier.ColumnIdentifier;
import org.datanucleus.store.rdbms.identifier.DatastoreIdentifier;
import org.datanucleus.store.rdbms.identifier.IdentifierCase;
import org.datanucleus.store.rdbms.identifier.IdentifierType;

public class JPAIdentifierFactory
extends AbstractIdentifierFactory {
    public JPAIdentifierFactory(DatastoreAdapter dba, ClassLoaderResolver clr, Map props) {
        super(dba, clr, props);
    }

    @Override
    public DatastoreIdentifier newTableIdentifier(AbstractMemberMetaData mmd) {
        String identifierName = null;
        String schemaName = null;
        String catalogName = null;
        AbstractMemberMetaData[] relatedMmds = null;
        if (mmd.getColumnMetaData().length > 0 && mmd.getColumnMetaData()[0].getName() != null) {
            identifierName = mmd.getColumnMetaData()[0].getName();
        } else if (mmd.hasContainer()) {
            String[] parts;
            String specifiedName;
            if (mmd.getTable() != null) {
                specifiedName = mmd.getTable();
                parts = this.getIdentifierNamePartsFromName(specifiedName);
                if (parts != null) {
                    catalogName = parts[0];
                    schemaName = parts[1];
                    identifierName = parts[2];
                }
                if (catalogName == null) {
                    catalogName = mmd.getCatalog();
                }
                if (schemaName == null) {
                    schemaName = mmd.getSchema();
                }
            } else {
                relatedMmds = mmd.getRelatedMemberMetaData(this.clr);
                if (relatedMmds != null && relatedMmds[0].getTable() != null) {
                    specifiedName = relatedMmds[0].getTable();
                    parts = this.getIdentifierNamePartsFromName(specifiedName);
                    if (parts != null) {
                        catalogName = parts[0];
                        schemaName = parts[1];
                        identifierName = parts[2];
                    }
                    if (catalogName == null) {
                        catalogName = relatedMmds[0].getCatalog();
                    }
                    if (schemaName == null) {
                        schemaName = relatedMmds[0].getSchema();
                    }
                }
            }
        }
        if (schemaName == null && catalogName == null) {
            if (mmd.getParent() instanceof AbstractClassMetaData) {
                AbstractClassMetaData ownerCmd = (AbstractClassMetaData)mmd.getParent();
                if (this.dba.supportsOption("CatalogInTableDefinition")) {
                    catalogName = ownerCmd.getCatalog();
                }
                if (this.dba.supportsOption("SchemaInTableDefinition")) {
                    schemaName = ownerCmd.getSchema();
                }
            }
            if (schemaName == null && catalogName == null) {
                if (this.dba.supportsOption("CatalogInTableDefinition")) {
                    catalogName = this.defaultCatalogName;
                }
                if (this.dba.supportsOption("SchemaInTableDefinition")) {
                    schemaName = this.defaultSchemaName;
                }
            }
        }
        if (identifierName == null) {
            String unique_name;
            String ownerClass = mmd.getClassName(false);
            String otherClass = mmd.getTypeName();
            if (mmd.hasCollection()) {
                otherClass = mmd.getCollection().getElementType();
            } else if (mmd.hasArray()) {
                otherClass = mmd.getArray().getElementType();
            } else if (mmd.hasMap()) {
                otherClass = mmd.getMap().getValueType();
            }
            if (mmd.hasCollection() && relatedMmds != null && relatedMmds[0].hasCollection() && mmd.getMappedBy() != null) {
                ownerClass = relatedMmds[0].getClassName(false);
                otherClass = relatedMmds[0].getCollection().getElementType();
            }
            otherClass = otherClass.substring(otherClass.lastIndexOf(46) + 1);
            identifierName = unique_name = ownerClass + this.getWordSeparator() + otherClass;
        }
        DatastoreIdentifier identifier = this.newTableIdentifier(identifierName);
        if (schemaName != null) {
            identifier.setSchemaName(schemaName);
        }
        if (catalogName != null) {
            identifier.setCatalogName(catalogName);
        }
        return identifier;
    }

    @Override
    public DatastoreIdentifier newTableIdentifier(AbstractClassMetaData cmd) {
        String identifierName = null;
        String schemaName = null;
        String catalogName = null;
        String specifiedName = cmd.getTable();
        String[] parts = this.getIdentifierNamePartsFromName(specifiedName);
        if (parts != null) {
            catalogName = parts[0];
            schemaName = parts[1];
            identifierName = parts[2];
        }
        if (schemaName == null && catalogName == null) {
            if (this.dba.supportsOption("CatalogInTableDefinition")) {
                catalogName = cmd.getCatalog();
            }
            if (this.dba.supportsOption("SchemaInTableDefinition")) {
                schemaName = cmd.getSchema();
            }
            if (schemaName == null && catalogName == null) {
                if (this.dba.supportsOption("CatalogInTableDefinition")) {
                    catalogName = this.defaultCatalogName;
                }
                if (this.dba.supportsOption("SchemaInTableDefinition")) {
                    schemaName = this.defaultSchemaName;
                }
            }
        }
        if (identifierName == null) {
            String unique_name;
            identifierName = unique_name = cmd.getFullClassName().substring(cmd.getFullClassName().lastIndexOf(46) + 1);
        }
        DatastoreIdentifier identifier = this.newTableIdentifier(identifierName);
        if (schemaName != null) {
            identifier.setSchemaName(schemaName);
        }
        if (catalogName != null) {
            identifier.setCatalogName(catalogName);
        }
        return identifier;
    }

    @Override
    public DatastoreIdentifier newReferenceFieldIdentifier(AbstractMemberMetaData refMetaData, AbstractClassMetaData implMetaData, DatastoreIdentifier implIdentifier, boolean embedded, int fieldRole) {
        String key = "[" + refMetaData.getFullFieldName() + "][" + implMetaData.getFullClassName() + "][" + implIdentifier.getIdentifierName() + "]";
        DatastoreIdentifier identifier = (DatastoreIdentifier)this.references.get(key);
        if (identifier == null) {
            String referenceName = refMetaData.getName();
            String implementationName = implMetaData.getFullClassName();
            int dot = implementationName.lastIndexOf(46);
            if (dot > -1) {
                implementationName = implementationName.substring(dot + 1);
            }
            String name = referenceName + "." + implementationName + "." + implIdentifier.getIdentifierName();
            String datastoreID = this.generateIdentifierNameForJavaName(name);
            String baseID = this.truncate(datastoreID, this.dba.getDatastoreIdentifierMaxLength(IdentifierType.COLUMN));
            identifier = new ColumnIdentifier(this, baseID);
            this.references.put(key, identifier);
        }
        return identifier;
    }

    @Override
    public DatastoreIdentifier newJoinTableFieldIdentifier(AbstractMemberMetaData ownerFmd, AbstractMemberMetaData relatedFmd, DatastoreIdentifier destinationId, boolean embedded, int fieldRole) {
        DatastoreIdentifier identifier = null;
        if (relatedFmd != null) {
            if (fieldRole == 1) {
                identifier = this.newColumnIdentifier(relatedFmd.getName() + this.getWordSeparator() + destinationId.getIdentifierName());
            } else if (fieldRole == 3 || fieldRole == 4 || fieldRole == 5 || fieldRole == 6) {
                if (destinationId != null) {
                    identifier = this.newColumnIdentifier(ownerFmd.getName() + this.getWordSeparator() + destinationId.getIdentifierName());
                } else if (fieldRole == 4 || fieldRole == 3) {
                    identifier = this.newColumnIdentifier(ownerFmd.getName() + this.getWordSeparator() + "ELEMENT");
                } else if (fieldRole == 5) {
                    identifier = this.newColumnIdentifier(ownerFmd.getName() + this.getWordSeparator() + "KEY");
                } else if (fieldRole == 6) {
                    identifier = this.newColumnIdentifier(ownerFmd.getName() + this.getWordSeparator() + "VALUE");
                }
            } else {
                identifier = this.newColumnIdentifier(destinationId.getIdentifierName(), embedded, fieldRole);
            }
        } else if (fieldRole == 1) {
            identifier = this.newColumnIdentifier(ownerFmd.getClassName(false) + this.getWordSeparator() + destinationId.getIdentifierName());
        } else if (fieldRole == 3 || fieldRole == 4 || fieldRole == 5 || fieldRole == 6) {
            if (destinationId != null) {
                identifier = this.newColumnIdentifier(ownerFmd.getName() + this.getWordSeparator() + destinationId.getIdentifierName());
            } else if (fieldRole == 4 || fieldRole == 3) {
                identifier = this.newColumnIdentifier(ownerFmd.getName() + this.getWordSeparator() + "ELEMENT");
            } else if (fieldRole == 5) {
                identifier = this.newColumnIdentifier(ownerFmd.getName() + this.getWordSeparator() + "KEY");
            } else if (fieldRole == 6) {
                identifier = this.newColumnIdentifier(ownerFmd.getName() + this.getWordSeparator() + "VALUE");
            }
        } else {
            identifier = this.newColumnIdentifier(destinationId.getIdentifierName(), embedded, fieldRole);
        }
        return identifier;
    }

    @Override
    public DatastoreIdentifier newForeignKeyFieldIdentifier(AbstractMemberMetaData ownerFmd, AbstractMemberMetaData relatedFmd, DatastoreIdentifier destinationId, boolean embedded, int fieldRole) {
        if (relatedFmd != null) {
            if (fieldRole == 1) {
                return this.newColumnIdentifier(relatedFmd.getName() + "." + destinationId.getIdentifierName(), embedded, fieldRole);
            }
            if (fieldRole == 7) {
                return this.newColumnIdentifier(relatedFmd.getName() + "." + destinationId.getIdentifierName(), embedded, fieldRole);
            }
            throw new NucleusException("Column role " + fieldRole + " not supported by this method").setFatal();
        }
        if (fieldRole == 1) {
            return this.newColumnIdentifier(ownerFmd.getName() + "." + destinationId.getIdentifierName(), embedded, fieldRole);
        }
        if (fieldRole == 7) {
            return this.newColumnIdentifier(ownerFmd.getName() + ".IDX", embedded, fieldRole);
        }
        throw new NucleusException("Column role " + fieldRole + " not supported by this method").setFatal();
    }

    @Override
    public DatastoreIdentifier newDiscriminatorFieldIdentifier() {
        String name = "DTYPE";
        DatastoreIdentifier identifier = (DatastoreIdentifier)this.columns.get(name);
        if (identifier == null) {
            identifier = new ColumnIdentifier(this, name);
            this.columns.put(name, identifier);
        }
        return identifier;
    }

    @Override
    public DatastoreIdentifier newVersionFieldIdentifier() {
        String name = "VERSION";
        DatastoreIdentifier identifier = (DatastoreIdentifier)this.columns.get(name);
        if (identifier == null) {
            identifier = new ColumnIdentifier(this, name);
            this.columns.put(name, identifier);
        }
        return identifier;
    }

    @Override
    public DatastoreIdentifier newIndexFieldIdentifier(AbstractMemberMetaData mmd) {
        String name = mmd.getName() + this.getWordSeparator() + "ORDER";
        DatastoreIdentifier identifier = (DatastoreIdentifier)this.columns.get(name);
        if (identifier == null) {
            identifier = new ColumnIdentifier(this, name);
            this.columns.put(name, identifier);
        }
        return identifier;
    }

    @Override
    public DatastoreIdentifier newAdapterIndexFieldIdentifier() {
        String name = "IDX";
        DatastoreIdentifier identifier = (DatastoreIdentifier)this.columns.get(name);
        if (identifier == null) {
            identifier = new ColumnIdentifier(this, name);
            this.columns.put(name, identifier);
        }
        return identifier;
    }

    @Override
    public String generateIdentifierNameForJavaName(String javaName) {
        if (javaName == null) {
            return null;
        }
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < javaName.length(); ++i) {
            char c = javaName.charAt(i);
            if (c >= 'A' && c <= 'Z' && this.identifierCase != IdentifierCase.MIXED_CASE && this.identifierCase != IdentifierCase.MIXED_CASE_QUOTED) {
                s.append(c);
                continue;
            }
            if (c >= 'A' && c <= 'Z' && (this.identifierCase == IdentifierCase.MIXED_CASE || this.identifierCase == IdentifierCase.MIXED_CASE_QUOTED)) {
                s.append(c);
                continue;
            }
            if (c >= 'a' && c <= 'z' && (this.identifierCase == IdentifierCase.MIXED_CASE || this.identifierCase == IdentifierCase.MIXED_CASE_QUOTED)) {
                s.append(c);
                continue;
            }
            if (c >= 'a' && c <= 'z' && this.identifierCase != IdentifierCase.MIXED_CASE && this.identifierCase != IdentifierCase.MIXED_CASE_QUOTED) {
                s.append((char)(c - 32));
                continue;
            }
            if (c >= '0' && c <= '9' || c == '_') {
                s.append(c);
                continue;
            }
            if (c == '.') {
                s.append(this.getWordSeparator());
                continue;
            }
            String cval = "000" + Integer.toHexString(c);
            s.append(cval.substring(cval.length() - (c > '\u00ff' ? 4 : 2)));
        }
        while (s.length() > 0 && s.charAt(0) == '_') {
            s.deleteCharAt(0);
        }
        if (s.length() == 0) {
            throw new IllegalArgumentException("Illegal Java identifier: " + javaName);
        }
        return s.toString();
    }

    @Override
    protected String getColumnIdentifierSuffix(int role, boolean embedded) {
        String suffix = "";
        if (role == 0) {
            suffix = !embedded ? "_ID" : "";
        }
        return suffix;
    }
}

