/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate.cfg;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.AnnotationDomainClassArtefactHandler;
import org.codehaus.groovy.grails.commons.ArtefactHandler;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsClass;
import org.codehaus.groovy.grails.commons.GrailsDomainClass;
import org.codehaus.groovy.grails.orm.hibernate.cfg.DefaultGrailsDomainConfiguration;
import org.codehaus.groovy.grails.orm.hibernate.cfg.GrailsDomainBinder;
import org.codehaus.groovy.grails.orm.hibernate.cfg.GrailsDomainConfiguration;
import org.codehaus.groovy.grails.orm.hibernate.cfg.GrailsHibernateUtil;
import org.codehaus.groovy.grails.orm.hibernate.cfg.Mapping;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.ImprovedNamingStrategy;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.engine.FilterDefinition;

public class GrailsAnnotationConfiguration
extends Configuration
implements GrailsDomainConfiguration {
    private static final Log LOG = LogFactory.getLog(GrailsAnnotationConfiguration.class);
    private static final long serialVersionUID = -7115087342689305517L;
    private GrailsApplication grailsApplication;
    private Set<GrailsDomainClass> domainClasses = new HashSet<GrailsDomainClass>();
    private boolean configLocked;
    private String sessionFactoryBeanName = "sessionFactory";
    private String dataSourceName = "DEFAULT";

    public GrailsDomainConfiguration addDomainClass(GrailsDomainClass domainClass) {
        if (this.shouldMapWithGorm(domainClass)) {
            this.domainClasses.add(domainClass);
        }
        return this;
    }

    private boolean shouldMapWithGorm(GrailsDomainClass domainClass) {
        return !AnnotationDomainClassArtefactHandler.isJPADomainClass((Class)domainClass.getClazz()) && domainClass.getMappingStrategy().equalsIgnoreCase("GORM");
    }

    public void setGrailsApplication(GrailsApplication application) {
        GrailsClass[] existingDomainClasses;
        this.grailsApplication = application;
        if (this.grailsApplication == null) {
            return;
        }
        this.configureNamingStrategy();
        for (GrailsClass existingDomainClass : existingDomainClasses = this.grailsApplication.getArtefacts("Domain")) {
            this.addDomainClass((GrailsDomainClass)existingDomainClass);
        }
        ArtefactHandler handler = this.grailsApplication.getArtefactHandler("Domain");
        if (!(handler instanceof AnnotationDomainClassArtefactHandler)) {
            return;
        }
        Set jpaDomainNames = ((AnnotationDomainClassArtefactHandler)handler).getJpaClassNames();
        if (jpaDomainNames == null) {
            return;
        }
        ClassLoader loader = this.grailsApplication.getClassLoader();
        for (String jpaDomainName : jpaDomainNames) {
            try {
                this.addAnnotatedClass(loader.loadClass(jpaDomainName));
            }
            catch (ClassNotFoundException e) {}
        }
    }

    public void setSessionFactoryBeanName(String name) {
        this.sessionFactoryBeanName = name;
    }

    public void setDataSourceName(String name) {
        this.dataSourceName = name;
    }

    public SessionFactory buildSessionFactory() throws HibernateException {
        if (this.grailsApplication != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"[GrailsAnnotationConfiguration] Setting context class loader to Grails GroovyClassLoader");
            }
            Thread.currentThread().setContextClassLoader(this.grailsApplication.getClassLoader());
        }
        this.addFilterDefinition(new FilterDefinition("dynamicFilterEnabler", "1=1", Collections.emptyMap()));
        SessionFactory sessionFactory = super.buildSessionFactory();
        if (this.grailsApplication != null) {
            GrailsHibernateUtil.configureHibernateDomainClasses(sessionFactory, this.sessionFactoryBeanName, this.grailsApplication);
        }
        return sessionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void secondPassCompile() throws MappingException {
        Thread currentThread = Thread.currentThread();
        ClassLoader originalContextLoader = currentThread.getContextClassLoader();
        if (!this.configLocked) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("[GrailsAnnotationConfiguration] [" + this.domainClasses.size() + "] Grails domain classes to bind to persistence runtime"));
            }
            DefaultGrailsDomainConfiguration.configureDomainBinder(this.grailsApplication, this.domainClasses);
            Iterator<GrailsDomainClass> i$ = this.domainClasses.iterator();
            while (i$.hasNext()) {
                Mapping m;
                ClassLoader loader = originalContextLoader;
                GrailsDomainClass domainClass = i$.next();
                String fullClassName = domainClass.getFullName();
                String hibernateConfig = fullClassName.replace('.', '/') + ".hbm.xml";
                if (loader.getResource(hibernateConfig) != null) continue;
                Mappings mappings = super.createMappings();
                if (!GrailsHibernateUtil.usesDatasource(domainClass, this.dataSourceName)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("[GrailsAnnotationConfiguration] Binding persistent class [" + fullClassName + "]"));
                }
                mappings.setAutoImport((m = GrailsDomainBinder.getMapping(domainClass)) == null || m.getAutoImport());
                GrailsDomainBinder.bindClass(domainClass, mappings, this.sessionFactoryBeanName);
            }
        }
        try {
            currentThread.setContextClassLoader(this.grailsApplication.getClassLoader());
            super.secondPassCompile();
        }
        finally {
            currentThread.setContextClassLoader(originalContextLoader);
        }
        this.configLocked = true;
    }

    private void configureNamingStrategy() {
        NamingStrategy strategy = null;
        Object customStrategy = this.grailsApplication.getFlatConfig().get("hibernate.naming_strategy");
        if (customStrategy != null) {
            Class<?> namingStrategyClass = null;
            if (customStrategy instanceof Class) {
                namingStrategyClass = (Class<?>)customStrategy;
            } else {
                try {
                    namingStrategyClass = this.grailsApplication.getClassLoader().loadClass(customStrategy.toString());
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            if (namingStrategyClass != null) {
                try {
                    strategy = (NamingStrategy)namingStrategyClass.newInstance();
                }
                catch (InstantiationException e) {
                }
                catch (IllegalAccessException e) {
                    // empty catch block
                }
            }
        }
        if (strategy == null) {
            strategy = ImprovedNamingStrategy.INSTANCE;
        }
        this.setNamingStrategy(strategy);
    }
}

