/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.sitemesh;

import com.opensymphony.module.sitemesh.HTMLPage;
import com.opensymphony.module.sitemesh.mapper.DefaultDecorator;
import com.opensymphony.sitemesh.Content;
import com.opensymphony.sitemesh.Decorator;
import com.opensymphony.sitemesh.SiteMeshContext;
import com.opensymphony.sitemesh.webapp.SiteMeshWebAppContext;
import groovy.text.Template;
import java.util.Collections;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.groovy.grails.web.servlet.view.AbstractGrailsView;
import org.codehaus.groovy.grails.web.sitemesh.GSPSitemeshPage;
import org.codehaus.groovy.grails.web.sitemesh.GrailsLayoutView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.AbstractUrlBasedView;

public class SpringMVCViewDecorator
extends DefaultDecorator
implements Decorator {
    private View view;

    public SpringMVCViewDecorator(String name, View view) {
        super(name, view instanceof AbstractUrlBasedView ? ((AbstractUrlBasedView)view).getUrl() : view.toString(), Collections.EMPTY_MAP);
        this.view = view;
    }

    public void render(Content content, SiteMeshContext context) {
        SiteMeshWebAppContext ctx = (SiteMeshWebAppContext)context;
        this.render(content, Collections.emptyMap(), ctx.getRequest(), ctx.getResponse(), ctx.getServletContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Content content, Map<String, ?> model, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        block9: {
            HTMLPage htmlPage = GSPSitemeshPage.content2htmlPage(content);
            request.setAttribute("__sitemesh__page", (Object)htmlPage);
            if (!response.isCommitted()) {
                boolean dispatched = false;
                try {
                    request.setAttribute(GrailsLayoutView.GSP_SITEMESH_PAGE, (Object)new GSPSitemeshPage(true));
                    try {
                        this.view.render(model, request, response);
                        dispatched = true;
                        if (!response.isCommitted()) {
                            response.getWriter().flush();
                        }
                    }
                    catch (Exception e) {
                        this.cleanRequestAttributes(request);
                        String message = "Error applying layout : " + this.getName();
                        if (this.view instanceof AbstractGrailsView) {
                            ((AbstractGrailsView)this.view).rethrowRenderException((Throwable)e, message);
                            break block9;
                        }
                        throw new RuntimeException(message, e);
                    }
                }
                finally {
                    if (!dispatched) {
                        this.cleanRequestAttributes(request);
                    }
                }
            }
        }
        request.removeAttribute("__sitemesh__page");
        request.removeAttribute(GrailsLayoutView.GSP_SITEMESH_PAGE);
    }

    private void cleanRequestAttributes(HttpServletRequest request) {
        request.removeAttribute("org.codehaus.groovy.grails.PAGE_SCOPE");
        request.removeAttribute("org.grails.layout.name");
    }

    public View getView() {
        return this.view;
    }

    public Template getTemplate() {
        if (this.view instanceof AbstractGrailsView) {
            return ((AbstractGrailsView)this.view).getTemplate();
        }
        return null;
    }
}

