/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cfg.pseudocode;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cfg.Label;
import org.jetbrains.kotlin.cfg.pseudocode.PseudoValue;
import org.jetbrains.kotlin.cfg.pseudocode.Pseudocode;
import org.jetbrains.kotlin.cfg.pseudocode.PseudocodeImpl;
import org.jetbrains.kotlin.cfg.pseudocode.PseudocodeLabel;
import org.jetbrains.kotlin.cfg.pseudocode.PseudocodeUtilsKt;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.Instruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.InstructionImpl;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.InstructionVisitor;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.InstructionWithNext;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.KtElementInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.MergeInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.AbstractJumpInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.ConditionalJumpInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.NondeterministicJumpInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.LocalFunctionDeclarationInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.SubroutineEnterInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.SubroutineExitInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.SubroutineSinkInstruction;
import org.jetbrains.kotlin.cfg.pseudocodeTraverser.PseudocodeTraverserKt;
import org.jetbrains.kotlin.cfg.pseudocodeTraverser.TraversalOrder;
import org.jetbrains.kotlin.com.google.common.collect.HashMultimap;
import org.jetbrains.kotlin.com.google.common.collect.Multimap;
import org.jetbrains.kotlin.com.intellij.util.containers.BidirectionalMap;
import org.jetbrains.kotlin.psi.KtElement;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010E\u001a\u00020F2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010G\u001a\u00020F2\u0006\u0010\u0012\u001a\u00020\u000fJ\u000e\u0010H\u001a\u00020F2\u0006\u0010I\u001a\u00020\u0016J\u0010\u0010J\u001a\u00020F2\u0006\u0010I\u001a\u00020KH\u0002J\u000e\u0010L\u001a\u00020F2\u0006\u0010@\u001a\u00020 J\u0018\u0010M\u001a\u00020F2\u0006\u0010N\u001a\u00020\t2\u0006\u0010O\u001a\u00020\u0016H\u0002J\u0016\u0010P\u001a\u00020F2\u0006\u0010Q\u001a\u00020\u00032\u0006\u0010N\u001a\u00020\tJ\u000e\u0010R\u001a\u00020F2\u0006\u0010S\u001a\u00020\"J\b\u0010T\u001a\u00020FH\u0002J\u000e\u0010U\u001a\b\u0012\u0004\u0012\u00020\u00160$H\u0002J\b\u0010V\u001a\u00020\u0000H\u0016J$\u0010W\u001a\u00020\u00162\u0006\u0010I\u001a\u00020\u00162\u0012\u0010X\u001a\u000e\u0012\u0004\u0012\u00020Z\u0012\u0004\u0012\u00020\"0YH\u0002J0\u0010[\u001a\b\u0012\u0004\u0012\u00020Z0D2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020Z0\\2\u0012\u0010X\u001a\u000e\u0012\u0004\u0012\u00020Z\u0012\u0004\u0012\u00020\"0YH\u0002J\u0018\u0010]\u001a\u00020\"2\u0006\u0010^\u001a\u00020_2\b\u0010`\u001a\u0004\u0018\u00010_J\u0014\u0010a\u001a\u0004\u0018\u00010\t2\b\u0010Q\u001a\u0004\u0018\u00010\u0003H\u0016J\u0010\u0010b\u001a\u00020\u00162\u0006\u0010c\u001a\u00020ZH\u0002J\f\u0010d\u001a\b\u0012\u0004\u0012\u00020\"0\u001aJ\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010e\u001a\u00020\u0001H\u0002J\u0016\u0010f\u001a\b\u0012\u0004\u0012\u00020\t0$2\u0006\u0010N\u001a\u00020\tH\u0002J\u0010\u0010g\u001a\u00020\u00162\u0006\u0010h\u001a\u00020iH\u0002J\u0018\u0010j\u001a\b\u0012\u0004\u0012\u00020\u00160D2\b\u0010N\u001a\u0004\u0018\u00010\tH\u0016J\u0018\u0010k\u001a\b\u0012\u0004\u0012\u00020\u00030\u001a2\b\u0010N\u001a\u0004\u0018\u00010\tH\u0016J\u0012\u0010l\u001a\u0004\u0018\u0001082\u0006\u0010Q\u001a\u00020\u0003H\u0016J\u0010\u0010m\u001a\u0002062\u0006\u0010I\u001a\u00020\u0016H\u0016J\b\u0010n\u001a\u00020FH\u0002J\u0006\u0010o\u001a\u00020FJ,\u0010p\u001a\u00020i2\u0006\u0010q\u001a\u00020\u00002\b\u0010r\u001a\u0004\u0018\u00010Z2\b\u0010s\u001a\u0004\u0018\u00010Z2\u0006\u0010t\u001a\u00020iH\u0002J8\u0010u\u001a\u00020F2\u0006\u0010v\u001a\u00020\u00162\u0012\u0010X\u001a\u000e\u0012\u0004\u0012\u00020Z\u0012\u0004\u0012\u00020\"0Y2\u0012\u0010w\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020Z0xH\u0002J\u001e\u0010y\u001a\u00020i2\u0006\u0010r\u001a\u00020Z2\u0006\u0010s\u001a\u00020Z2\u0006\u0010z\u001a\u00020iJ\u0010\u0010{\u001a\u00020F2\u0006\u0010q\u001a\u00020\u0000H\u0002J\u0014\u0010|\u001a\u00020F*\u00020\u00162\u0006\u0010h\u001a\u00020iH\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b(\u0010)\u001a\u0004\b&\u0010'R6\u0010*\u001a*\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0$0+j\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0$`,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\u0018R(\u00100\u001a\u0004\u0018\u00010\u00012\b\u0010/\u001a\u0004\u0018\u00010\u0001@RX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\u000e\u00105\u001a\u000206X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00107\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002080+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00109\u001a\b\u0012\u0004\u0012\u00020\u00160\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010\u001cR\u0011\u0010;\u001a\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b<\u00102R\u001e\u0010=\u001a\u0012\u0012\u0004\u0012\u00020\u00160>j\b\u0012\u0004\u0012\u00020\u0016`?X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010@\u001a\u00020 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bA\u0010BR6\u0010C\u001a*\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160D0+j\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160D`,X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006}"}, d2={"Lorg/jetbrains/kotlin/cfg/pseudocode/PseudocodeImpl;", "Lorg/jetbrains/kotlin/cfg/pseudocode/Pseudocode;", "correspondingElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "(Lorg/jetbrains/kotlin/psi/KtElement;)V", "getCorrespondingElement", "()Lorg/jetbrains/kotlin/psi/KtElement;", "elementsToValues", "Lorg/jetbrains/kotlin/com/intellij/util/containers/BidirectionalMap;", "Lorg/jetbrains/kotlin/cfg/pseudocode/PseudoValue;", "enterInstruction", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/special/SubroutineEnterInstruction;", "getEnterInstruction", "()Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/special/SubroutineEnterInstruction;", "errorInstruction", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/special/SubroutineExitInstruction;", "getErrorInstruction", "()Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/special/SubroutineExitInstruction;", "exitInstruction", "getExitInstruction", "instructions", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/Instruction;", "getInstructions", "()Ljava/util/ArrayList;", "instructionsIncludingDeadCode", "", "getInstructionsIncludingDeadCode", "()Ljava/util/List;", "internalErrorInstruction", "internalExitInstruction", "internalSinkInstruction", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/special/SubroutineSinkInstruction;", "labels", "Lorg/jetbrains/kotlin/cfg/pseudocode/PseudocodeLabel;", "localDeclarations", "", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/special/LocalFunctionDeclarationInstruction;", "getLocalDeclarations", "()Ljava/util/Set;", "localDeclarations$delegate", "Lkotlin/Lazy;", "mergedValues", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "mutableInstructionList", "getMutableInstructionList$kotlin_compiler", "<set-?>", "parent", "getParent", "()Lorg/jetbrains/kotlin/cfg/pseudocode/Pseudocode;", "setParent", "(Lorg/jetbrains/kotlin/cfg/pseudocode/Pseudocode;)V", "postPrecessed", "", "representativeInstructions", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/KtElementInstruction;", "reversedInstructions", "getReversedInstructions", "rootPseudocode", "getRootPseudocode", "sideEffectFree", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "sinkInstruction", "getSinkInstruction", "()Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/special/SubroutineSinkInstruction;", "valueUsages", "", "addErrorInstruction", "", "addExitInstruction", "addInstruction", "instruction", "addMergedValues", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/eval/MergeInstruction;", "addSinkInstruction", "addValueUsage", "value", "usage", "bindElementToValue", "element", "bindLabel", "label", "collectAndCacheReachableInstructions", "collectReachableInstructions", "copy", "copyInstruction", "originalToCopy", "", "Lorg/jetbrains/kotlin/cfg/Label;", "copyLabels", "", "createLabel", "name", "", "comment", "getElementValue", "getJumpTarget", "targetLabel", "getLabels", "pseudocode", "getMergedValues", "getNextPosition", "currentPosition", "", "getUsages", "getValueElements", "instructionForElement", "isSideEffectFree", "markDeadInstructions", "postProcess", "repeatInternal", "originalPseudocode", "startLabel", "finishLabel", "labelCountArg", "repeatLabelsBindingForInstruction", "originalInstruction", "originalLabelsForInstruction", "Lorg/jetbrains/kotlin/com/google/common/collect/Multimap;", "repeatPart", "labelCount", "repeatWhole", "processInstruction", "kotlin-compiler"})
public final class PseudocodeImpl
implements Pseudocode {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private final ArrayList<Instruction> mutableInstructionList;
    @NotNull
    private final ArrayList<Instruction> instructions;
    private final BidirectionalMap<KtElement, PseudoValue> elementsToValues;
    private final HashMap<PseudoValue, List<Instruction>> valueUsages;
    private final HashMap<PseudoValue, Set<PseudoValue>> mergedValues;
    private final HashSet<Instruction> sideEffectFree;
    @Nullable
    private Pseudocode parent;
    @NotNull
    private final Lazy localDeclarations$delegate;
    private final HashMap<KtElement, KtElementInstruction> representativeInstructions;
    private final ArrayList<PseudocodeLabel> labels;
    private SubroutineExitInstruction internalExitInstruction;
    private SubroutineSinkInstruction internalSinkInstruction;
    private SubroutineExitInstruction internalErrorInstruction;
    private boolean postPrecessed;
    @NotNull
    private final KtElement correspondingElement;

    static {
        $$delegatedProperties = new KProperty[]{Reflection.property1(new PropertyReference1Impl(Reflection.getOrCreateKotlinClass(PseudocodeImpl.class), "localDeclarations", "getLocalDeclarations()Ljava/util/Set;"))};
    }

    @NotNull
    public final ArrayList<Instruction> getMutableInstructionList$kotlin_compiler() {
        return this.mutableInstructionList;
    }

    @NotNull
    public ArrayList<Instruction> getInstructions() {
        return this.instructions;
    }

    @Override
    @Nullable
    public Pseudocode getParent() {
        return this.parent;
    }

    private void setParent(Pseudocode pseudocode) {
        this.parent = pseudocode;
    }

    @Override
    @NotNull
    public Set<LocalFunctionDeclarationInstruction> getLocalDeclarations() {
        Lazy lazy = this.localDeclarations$delegate;
        PseudocodeImpl pseudocodeImpl = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (Set)lazy.getValue();
    }

    @Override
    @NotNull
    public SubroutineExitInstruction getExitInstruction() {
        SubroutineExitInstruction subroutineExitInstruction = this.internalExitInstruction;
        if (subroutineExitInstruction == null) {
            throw (Throwable)((Object)new AssertionError((Object)"Exit instruction is read before initialization"));
        }
        return subroutineExitInstruction;
    }

    @Override
    @NotNull
    public SubroutineSinkInstruction getSinkInstruction() {
        SubroutineSinkInstruction subroutineSinkInstruction = this.internalSinkInstruction;
        if (subroutineSinkInstruction == null) {
            throw (Throwable)((Object)new AssertionError((Object)"Sink instruction is read before initialization"));
        }
        return subroutineSinkInstruction;
    }

    @Override
    @NotNull
    public SubroutineExitInstruction getErrorInstruction() {
        SubroutineExitInstruction subroutineExitInstruction = this.internalErrorInstruction;
        if (subroutineExitInstruction == null) {
            throw (Throwable)((Object)new AssertionError((Object)"Error instruction is read before initialization"));
        }
        return subroutineExitInstruction;
    }

    private final Set<LocalFunctionDeclarationInstruction> getLocalDeclarations(Pseudocode pseudocode) {
        LinkedHashSet<Instruction> localDeclarations2 = new LinkedHashSet<Instruction>();
        Pseudocode pseudocode2 = pseudocode;
        if (pseudocode2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.cfg.pseudocode.PseudocodeImpl");
        }
        for (Instruction instruction : ((PseudocodeImpl)pseudocode2).mutableInstructionList) {
            if (!(instruction instanceof LocalFunctionDeclarationInstruction)) continue;
            localDeclarations2.add(instruction);
            localDeclarations2.addAll((Collection)this.getLocalDeclarations(((LocalFunctionDeclarationInstruction)instruction).getBody()));
        }
        return localDeclarations2;
    }

    @NotNull
    public final Pseudocode getRootPseudocode() {
        for (Pseudocode parent2 = this.getParent(); parent2 != null; parent2 = parent2.getParent()) {
            if (parent2.getParent() != null) continue;
            return parent2;
        }
        return this;
    }

    @NotNull
    public final PseudocodeLabel createLabel(@NotNull String name, @Nullable String comment) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        PseudocodeLabel label = new PseudocodeLabel(this, name, comment);
        this.labels.add(label);
        return label;
    }

    @Override
    @NotNull
    public List<Instruction> getReversedInstructions() {
        LinkedHashSet traversedInstructions = new LinkedHashSet();
        PseudocodeTraverserKt.traverseFollowingInstructions(this.getSinkInstruction(), traversedInstructions, TraversalOrder.BACKWARD, null);
        if (traversedInstructions.size() < ((ArrayList)this.getInstructions()).size()) {
            List<Instruction> simplyReversedInstructions = CollectionsKt.reversed(this.getInstructions());
            for (Instruction instruction : simplyReversedInstructions) {
                if (traversedInstructions.contains(instruction)) continue;
                PseudocodeTraverserKt.traverseFollowingInstructions(instruction, traversedInstructions, TraversalOrder.BACKWARD, null);
            }
        }
        return CollectionsKt.toList(traversedInstructions);
    }

    @Override
    @NotNull
    public List<Instruction> getInstructionsIncludingDeadCode() {
        return this.mutableInstructionList;
    }

    @NotNull
    public final List<PseudocodeLabel> getLabels() {
        return this.labels;
    }

    public final void addExitInstruction(@NotNull SubroutineExitInstruction exitInstruction) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(exitInstruction, "exitInstruction");
        this.addInstruction(exitInstruction);
        boolean bl2 = bl = this.internalExitInstruction == null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Repeated initialization of exit instruction: " + this.internalExitInstruction + " --> " + exitInstruction;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.internalExitInstruction = exitInstruction;
    }

    public final void addSinkInstruction(@NotNull SubroutineSinkInstruction sinkInstruction) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(sinkInstruction, "sinkInstruction");
        this.addInstruction(sinkInstruction);
        boolean bl2 = bl = this.internalSinkInstruction == null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Repeated initialization of sink instruction: " + this.internalSinkInstruction + " --> " + sinkInstruction;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.internalSinkInstruction = sinkInstruction;
    }

    public final void addErrorInstruction(@NotNull SubroutineExitInstruction errorInstruction) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(errorInstruction, "errorInstruction");
        this.addInstruction(errorInstruction);
        boolean bl2 = bl = this.internalErrorInstruction == null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Repeated initialization of error instruction: " + this.internalErrorInstruction + " --> " + errorInstruction;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.internalErrorInstruction = errorInstruction;
    }

    public final void addInstruction(@NotNull Instruction instruction) {
        Intrinsics.checkParameterIsNotNull(instruction, "instruction");
        this.mutableInstructionList.add(instruction);
        instruction.setOwner(this);
        if (instruction instanceof KtElementInstruction && !this.representativeInstructions.containsKey(((KtElementInstruction)instruction).getElement())) {
            this.representativeInstructions.put(((KtElementInstruction)instruction).getElement(), (KtElementInstruction)instruction);
        }
        if (instruction instanceof MergeInstruction) {
            this.addMergedValues((MergeInstruction)instruction);
        }
        for (PseudoValue inputValue : instruction.getInputValues()) {
            this.addValueUsage(inputValue, instruction);
            for (PseudoValue mergedValue : this.getMergedValues(inputValue)) {
                this.addValueUsage(mergedValue, instruction);
            }
        }
        if (PseudocodeUtilsKt.calcSideEffectFree(instruction)) {
            this.sideEffectFree.add(instruction);
        }
    }

    @Override
    @NotNull
    public SubroutineEnterInstruction getEnterInstruction() {
        Instruction instruction = this.mutableInstructionList.get(0);
        if (instruction == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.cfg.pseudocode.instructions.special.SubroutineEnterInstruction");
        }
        return (SubroutineEnterInstruction)instruction;
    }

    @Override
    @Nullable
    public PseudoValue getElementValue(@Nullable KtElement element) {
        return this.elementsToValues.get(element);
    }

    @Override
    @NotNull
    public List<KtElement> getValueElements(@Nullable PseudoValue value) {
        List<KtElement> list2 = this.elementsToValues.getKeysByValue(value);
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    @Override
    @NotNull
    public List<Instruction> getUsages(@Nullable PseudoValue value) {
        Map map2;
        Map map3 = map2 = (Map)this.valueUsages;
        if (map3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, V>");
        }
        List list2 = (List)map3.get(value);
        if (list2 == null) {
            list2 = new ArrayList();
        }
        return list2;
    }

    @Override
    public boolean isSideEffectFree(@NotNull Instruction instruction) {
        Intrinsics.checkParameterIsNotNull(instruction, "instruction");
        return this.sideEffectFree.contains(instruction);
    }

    public final void bindElementToValue(@NotNull KtElement element, @NotNull PseudoValue value) {
        Intrinsics.checkParameterIsNotNull(element, "element");
        Intrinsics.checkParameterIsNotNull(value, "value");
        this.elementsToValues.put(element, value);
    }

    public final void bindLabel(@NotNull PseudocodeLabel label) {
        Intrinsics.checkParameterIsNotNull(label, "label");
        boolean bl = Intrinsics.areEqual(this, label.getPseudocode());
        if (_Assertions.ENABLED && !bl) {
            String string = "Attempt to bind label " + label + " to instruction from different pseudocode: " + "\nowner pseudocode = " + label.getPseudocode().mutableInstructionList + ", " + "\nbound pseudocode = " + this.mutableInstructionList;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        label.setTargetInstructionIndex(this.mutableInstructionList.size());
    }

    private final Set<PseudoValue> getMergedValues(PseudoValue value) {
        Set<PseudoValue> set = this.mergedValues.get(value);
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    private final void addMergedValues(MergeInstruction instruction) {
        LinkedHashSet<PseudoValue> result2 = new LinkedHashSet<PseudoValue>();
        for (PseudoValue value : instruction.getInputValues()) {
            result2.addAll((Collection)this.getMergedValues(value));
            result2.add(value);
        }
        this.mergedValues.put(instruction.getOutputValue(), result2);
    }

    private final void addValueUsage(PseudoValue value, Instruction usage) {
        Object object;
        if (usage instanceof MergeInstruction) {
            return;
        }
        Map $receiver$iv = this.valueUsages;
        Object value$iv = $receiver$iv.get(value);
        if (value$iv == null) {
            ArrayList answer$iv = new ArrayList();
            $receiver$iv.put(value, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ((List)object).add(usage);
    }

    public final void postProcess() {
        if (this.postPrecessed) {
            return;
        }
        this.postPrecessed = true;
        this.getErrorInstruction().setSink(this.getSinkInstruction());
        this.getExitInstruction().setSink(this.getSinkInstruction());
        for (IndexedValue indexedValue : CollectionsKt.withIndex((Iterable)this.mutableInstructionList)) {
            int index2 = indexedValue.component1();
            Instruction instruction = (Instruction)indexedValue.component2();
            this.processInstruction(instruction, index2);
        }
        if (this.getParent() != null) {
            return;
        }
        this.collectAndCacheReachableInstructions();
        for (LocalFunctionDeclarationInstruction localFunctionDeclarationInstruction : this.getLocalDeclarations()) {
            Pseudocode pseudocode = localFunctionDeclarationInstruction.getBody();
            if (pseudocode == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.cfg.pseudocode.PseudocodeImpl");
            }
            ((PseudocodeImpl)pseudocode).collectAndCacheReachableInstructions();
        }
    }

    private final void collectAndCacheReachableInstructions() {
        Set<Instruction> reachableInstructions = this.collectReachableInstructions();
        for (Instruction instruction : this.mutableInstructionList) {
            if (!reachableInstructions.contains(instruction)) continue;
            ((ArrayList)this.getInstructions()).add(instruction);
        }
        this.markDeadInstructions();
    }

    private final void processInstruction(@NotNull Instruction $receiver, int currentPosition) {
        $receiver.accept(new InstructionVisitor(this, currentPosition){
            final /* synthetic */ PseudocodeImpl this$0;
            final /* synthetic */ int $currentPosition;

            public void visitInstructionWithNext(@NotNull InstructionWithNext instruction) {
                Intrinsics.checkParameterIsNotNull(instruction, "instruction");
                instruction.setNext(PseudocodeImpl.access$getNextPosition(this.this$0, this.$currentPosition));
            }

            public void visitJump(@NotNull AbstractJumpInstruction instruction) {
                Intrinsics.checkParameterIsNotNull(instruction, "instruction");
                instruction.setResolvedTarget(PseudocodeImpl.access$getJumpTarget(this.this$0, instruction.getTargetLabel()));
            }

            public void visitNondeterministicJump(@NotNull NondeterministicJumpInstruction instruction) {
                Intrinsics.checkParameterIsNotNull(instruction, "instruction");
                instruction.setNext(PseudocodeImpl.access$getNextPosition(this.this$0, this.$currentPosition));
                List<Label> targetLabels = instruction.getTargetLabels();
                for (Label targetLabel : targetLabels) {
                    instruction.setResolvedTarget(targetLabel, PseudocodeImpl.access$getJumpTarget(this.this$0, targetLabel));
                }
            }

            public void visitConditionalJump(@NotNull ConditionalJumpInstruction instruction) {
                Intrinsics.checkParameterIsNotNull(instruction, "instruction");
                Instruction nextInstruction = PseudocodeImpl.access$getNextPosition(this.this$0, this.$currentPosition);
                Instruction jumpTarget = PseudocodeImpl.access$getJumpTarget(this.this$0, instruction.getTargetLabel());
                if (instruction.getOnTrue()) {
                    instruction.setNextOnFalse(nextInstruction);
                    instruction.setNextOnTrue(jumpTarget);
                } else {
                    instruction.setNextOnFalse(jumpTarget);
                    instruction.setNextOnTrue(nextInstruction);
                }
                this.visitJump(instruction);
            }

            public void visitLocalFunctionDeclarationInstruction(@NotNull LocalFunctionDeclarationInstruction instruction) {
                Intrinsics.checkParameterIsNotNull(instruction, "instruction");
                Pseudocode pseudocode = instruction.getBody();
                if (pseudocode == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.cfg.pseudocode.PseudocodeImpl");
                }
                PseudocodeImpl body = (PseudocodeImpl)pseudocode;
                PseudocodeImpl.access$setParent$p(body, this.this$0);
                body.postProcess();
                instruction.setNext(this.this$0.getSinkInstruction());
            }

            public void visitSubroutineExit(@NotNull SubroutineExitInstruction instruction) {
                Intrinsics.checkParameterIsNotNull(instruction, "instruction");
            }

            public void visitSubroutineSink(@NotNull SubroutineSinkInstruction instruction) {
                Intrinsics.checkParameterIsNotNull(instruction, "instruction");
            }

            public void visitInstruction(@NotNull Instruction instruction) {
                Intrinsics.checkParameterIsNotNull(instruction, "instruction");
                throw (Throwable)new UnsupportedOperationException(instruction.toString());
            }
            {
                this.this$0 = $outer;
                this.$currentPosition = $captured_local_variable$1;
            }
        });
    }

    private final Set<Instruction> collectReachableInstructions() {
        HashSet<InstructionImpl> visited2 = new HashSet<InstructionImpl>();
        PseudocodeTraverserKt.traverseFollowingInstructions(this.getEnterInstruction(), (Set<Instruction>)visited2, TraversalOrder.FORWARD, collectReachableInstructions.1.INSTANCE);
        if (!visited2.contains(this.getExitInstruction())) {
            visited2.add(this.getExitInstruction());
        }
        if (!visited2.contains(this.getErrorInstruction())) {
            visited2.add(this.getErrorInstruction());
        }
        if (!visited2.contains(this.getSinkInstruction())) {
            visited2.add(this.getSinkInstruction());
        }
        return visited2;
    }

    private final void markDeadInstructions() {
        HashSet instructionSet = CollectionsKt.toHashSet(this.getInstructions());
        for (Instruction instruction : this.mutableInstructionList) {
            if (instructionSet.contains(instruction)) continue;
            Instruction instruction2 = instruction;
            if (!(instruction2 instanceof InstructionImpl)) {
                instruction2 = null;
            }
            InstructionImpl instructionImpl = (InstructionImpl)instruction2;
            if (instructionImpl != null) {
                instructionImpl.setMarkedAsDead(true);
            }
            for (Instruction nextInstruction : instruction.getNextInstructions()) {
                Object object;
                Instruction instruction3 = nextInstruction;
                if (!(instruction3 instanceof InstructionImpl)) {
                    instruction3 = null;
                }
                if ((object = (InstructionImpl)instruction3) == null || (object = ((InstructionImpl)object).getPreviousInstructions()) == null) continue;
                object.remove(instruction);
            }
        }
    }

    private final Instruction getJumpTarget(Label targetLabel) {
        return targetLabel.resolveToInstruction();
    }

    private final Instruction getNextPosition(int currentPosition) {
        boolean bl;
        int targetPosition = currentPosition + 1;
        boolean bl2 = bl = targetPosition < this.mutableInstructionList.size();
        if (_Assertions.ENABLED && !bl) {
            Integer n = currentPosition;
            throw (Throwable)((Object)new AssertionError(n));
        }
        Instruction instruction = this.mutableInstructionList.get(targetPosition);
        Intrinsics.checkExpressionValueIsNotNull(instruction, "mutableInstructionList[targetPosition]");
        return instruction;
    }

    @Override
    @NotNull
    public PseudocodeImpl copy() {
        PseudocodeImpl result2 = new PseudocodeImpl(this.getCorrespondingElement());
        result2.repeatWhole(this);
        return result2;
    }

    @Override
    @Nullable
    public KtElementInstruction instructionForElement(@NotNull KtElement element) {
        Intrinsics.checkParameterIsNotNull(element, "element");
        return this.representativeInstructions.get(element);
    }

    private final void repeatWhole(PseudocodeImpl originalPseudocode) {
        this.repeatInternal(originalPseudocode, null, null, 0);
        this.setParent(originalPseudocode.getParent());
    }

    public final int repeatPart(@NotNull Label startLabel, @NotNull Label finishLabel, int labelCount) {
        Intrinsics.checkParameterIsNotNull(startLabel, "startLabel");
        Intrinsics.checkParameterIsNotNull(finishLabel, "finishLabel");
        Pseudocode pseudocode = startLabel.getPseudocode();
        if (pseudocode == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.cfg.pseudocode.PseudocodeImpl");
        }
        return this.repeatInternal((PseudocodeImpl)pseudocode, startLabel, finishLabel, labelCount);
    }

    /*
     * WARNING - void declaration
     */
    private final int repeatInternal(PseudocodeImpl originalPseudocode, Label startLabel, Label finishLabel, int labelCountArg) {
        int labelCount = labelCountArg;
        Label label = startLabel;
        int startIndex = label != null ? label.getTargetInstructionIndex() : 0;
        Label label2 = finishLabel;
        int finishIndex = label2 != null ? label2.getTargetInstructionIndex() : originalPseudocode.mutableInstructionList.size();
        LinkedHashMap<PseudocodeLabel, PseudocodeLabel> originalToCopy = new LinkedHashMap<PseudocodeLabel, PseudocodeLabel>();
        HashMultimap originalLabelsForInstruction = HashMultimap.create();
        for (PseudocodeLabel label3 : originalPseudocode.labels) {
            int index2 = label3.getTargetInstructionIndex();
            if (index2 < 0 || label3 == startLabel || label3 == finishLabel) continue;
            int n = index2;
            if (startIndex > n || finishIndex < n) continue;
            originalToCopy.put(label3, label3.copy(this, labelCount++));
            PseudocodeLabel pseudocodeLabel = label3;
            Intrinsics.checkExpressionValueIsNotNull(pseudocodeLabel, "label");
            originalLabelsForInstruction.put(this.getJumpTarget(pseudocodeLabel), label3);
        }
        for (PseudocodeLabel label3 : originalToCopy.values()) {
            this.labels.add(label3);
        }
        int label4 = startIndex;
        int n = finishIndex;
        while (label4 < n) {
            void index3;
            Instruction originalInstruction;
            Instruction instruction = originalInstruction = originalPseudocode.mutableInstructionList.get((int)index3);
            Intrinsics.checkExpressionValueIsNotNull(instruction, "originalInstruction");
            Map map2 = originalToCopy;
            HashMultimap hashMultimap = originalLabelsForInstruction;
            Intrinsics.checkExpressionValueIsNotNull(hashMultimap, "originalLabelsForInstruction");
            this.repeatLabelsBindingForInstruction(instruction, map2, hashMultimap);
            Instruction copy = this.copyInstruction(originalInstruction, (Map<Label, PseudocodeLabel>)originalToCopy);
            this.addInstruction(copy);
            if (originalInstruction == originalPseudocode.internalErrorInstruction && copy instanceof SubroutineExitInstruction) {
                this.internalErrorInstruction = (SubroutineExitInstruction)copy;
            }
            if (originalInstruction == originalPseudocode.internalExitInstruction && copy instanceof SubroutineExitInstruction) {
                this.internalExitInstruction = (SubroutineExitInstruction)copy;
            }
            if (originalInstruction == originalPseudocode.internalSinkInstruction && copy instanceof SubroutineSinkInstruction) {
                this.internalSinkInstruction = (SubroutineSinkInstruction)copy;
            }
            ++index3;
        }
        if (finishIndex < originalPseudocode.mutableInstructionList.size()) {
            Instruction instruction = originalPseudocode.mutableInstructionList.get(finishIndex);
            Intrinsics.checkExpressionValueIsNotNull(instruction, "originalPseudocode.mutab\u2026tructionList[finishIndex]");
            Map map3 = originalToCopy;
            HashMultimap hashMultimap = originalLabelsForInstruction;
            Intrinsics.checkExpressionValueIsNotNull(hashMultimap, "originalLabelsForInstruction");
            this.repeatLabelsBindingForInstruction(instruction, map3, hashMultimap);
        }
        return labelCount;
    }

    private final void repeatLabelsBindingForInstruction(Instruction originalInstruction, Map<Label, PseudocodeLabel> originalToCopy, Multimap<Instruction, Label> originalLabelsForInstruction) {
        for (Label originalLabel : originalLabelsForInstruction.get(originalInstruction)) {
            PseudocodeLabel pseudocodeLabel = originalToCopy.get(originalLabel);
            if (pseudocodeLabel == null) {
                Intrinsics.throwNpe();
            }
            this.bindLabel(pseudocodeLabel);
        }
    }

    private final Instruction copyInstruction(Instruction instruction, Map<Label, PseudocodeLabel> originalToCopy) {
        Label originalTarget;
        if (instruction instanceof AbstractJumpInstruction && originalToCopy.containsKey(originalTarget = ((AbstractJumpInstruction)instruction).getTargetLabel())) {
            AbstractJumpInstruction abstractJumpInstruction = (AbstractJumpInstruction)instruction;
            PseudocodeLabel pseudocodeLabel = originalToCopy.get(originalTarget);
            if (pseudocodeLabel == null) {
                Intrinsics.throwNpe();
            }
            return abstractJumpInstruction.copy(pseudocodeLabel);
        }
        if (instruction instanceof NondeterministicJumpInstruction) {
            List<Label> originalTargets = ((NondeterministicJumpInstruction)instruction).getTargetLabels();
            List<Label> copyTargets = this.copyLabels((Collection<? extends Label>)originalTargets, originalToCopy);
            return ((NondeterministicJumpInstruction)instruction).copy(copyTargets);
        }
        Instruction instruction2 = instruction;
        if (instruction2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.cfg.pseudocode.instructions.InstructionImpl");
        }
        return ((InstructionImpl)instruction2).copy();
    }

    private final List<Label> copyLabels(Collection<? extends Label> labels2, Map<Label, PseudocodeLabel> originalToCopy) {
        ArrayList<Label> newLabels = new ArrayList<Label>();
        for (Label label : labels2) {
            PseudocodeLabel newLabel;
            PseudocodeLabel pseudocodeLabel = newLabel = originalToCopy.get(label);
            newLabels.add(pseudocodeLabel != null ? (Label)pseudocodeLabel : label);
        }
        return newLabels;
    }

    @Override
    @NotNull
    public KtElement getCorrespondingElement() {
        return this.correspondingElement;
    }

    public PseudocodeImpl(@NotNull KtElement correspondingElement) {
        Intrinsics.checkParameterIsNotNull(correspondingElement, "correspondingElement");
        this.correspondingElement = correspondingElement;
        this.mutableInstructionList = new ArrayList();
        this.instructions = new ArrayList();
        this.elementsToValues = new BidirectionalMap();
        PseudocodeImpl pseudocodeImpl = this;
        Cloneable cloneable2 = new HashMap();
        pseudocodeImpl.valueUsages = cloneable2;
        pseudocodeImpl = this;
        cloneable2 = new HashMap();
        pseudocodeImpl.mergedValues = cloneable2;
        pseudocodeImpl = this;
        cloneable2 = new HashSet();
        pseudocodeImpl.sideEffectFree = cloneable2;
        this.localDeclarations$delegate = LazyKt.lazy((Function0)new Function0<Set<? extends LocalFunctionDeclarationInstruction>>(this){
            final /* synthetic */ PseudocodeImpl this$0;

            @NotNull
            public final Set<LocalFunctionDeclarationInstruction> invoke() {
                return PseudocodeImpl.access$getLocalDeclarations(this.this$0, this.this$0);
            }
            {
                this.this$0 = pseudocodeImpl;
                super(0);
            }
        });
        this.representativeInstructions = new HashMap();
        this.labels = new ArrayList();
    }

    @NotNull
    public static final /* synthetic */ Instruction access$getNextPosition(PseudocodeImpl $this, int currentPosition) {
        return $this.getNextPosition(currentPosition);
    }

    @NotNull
    public static final /* synthetic */ Instruction access$getJumpTarget(PseudocodeImpl $this, @NotNull Label targetLabel) {
        return $this.getJumpTarget(targetLabel);
    }

    @Nullable
    public static final /* synthetic */ Pseudocode access$getParent$p(PseudocodeImpl $this) {
        return $this.getParent();
    }

    public static final /* synthetic */ void access$setParent$p(PseudocodeImpl $this, @Nullable Pseudocode pseudocode) {
        $this.setParent(pseudocode);
    }

    @NotNull
    public static final /* synthetic */ Set access$getLocalDeclarations(PseudocodeImpl $this, @NotNull Pseudocode pseudocode) {
        return $this.getLocalDeclarations(pseudocode);
    }
}

