/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.vfs.newvfs.events;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileSystem;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.newvfs.events.VFileEvent;

public class VFileMoveEvent
extends VFileEvent {
    private final VirtualFile myFile;
    private final VirtualFile myOldParent;
    private final VirtualFile myNewParent;

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile2 = this.myFile;
        if (virtualFile2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/vfs/newvfs/events/VFileMoveEvent", "getFile"));
        }
        return virtualFile2;
    }

    @NotNull
    public VirtualFile getNewParent() {
        VirtualFile virtualFile2 = this.myNewParent;
        if (virtualFile2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/vfs/newvfs/events/VFileMoveEvent", "getNewParent"));
        }
        return virtualFile2;
    }

    public VirtualFile getOldParent() {
        return this.myOldParent;
    }

    @NonNls
    public String toString() {
        return "VfsEvent[move " + this.myFile.getName() + " from " + this.myOldParent + " to " + this.myNewParent + "]";
    }

    @Override
    @NotNull
    public VirtualFileSystem getFileSystem() {
        VirtualFileSystem virtualFileSystem = this.myFile.getFileSystem();
        if (virtualFileSystem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/vfs/newvfs/events/VFileMoveEvent", "getFileSystem"));
        }
        return virtualFileSystem;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VFileMoveEvent event = (VFileMoveEvent)o;
        if (!this.myFile.equals(event.myFile)) {
            return false;
        }
        if (!this.myNewParent.equals(event.myNewParent)) {
            return false;
        }
        return this.myOldParent.equals(event.myOldParent);
    }

    public int hashCode() {
        int result2 = this.myFile.hashCode();
        result2 = 31 * result2 + this.myOldParent.hashCode();
        result2 = 31 * result2 + this.myNewParent.hashCode();
        return result2;
    }
}

