/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.js.resolve.diagnostics.JsModuleCheckUtilKt;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.checkers.SimpleDeclarationChecker;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J(\u0010\r\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/js/resolve/diagnostics/JsModuleChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/SimpleDeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "checkSuperClass", "kotlin-compiler"})
public final class JsModuleChecker
implements SimpleDeclarationChecker {
    public static final JsModuleChecker INSTANCE;

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder, @NotNull BindingContext bindingContext) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(diagnosticHolder, "diagnosticHolder");
        Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
        this.checkSuperClass(bindingContext, diagnosticHolder, descriptor2, declaration);
        if (AnnotationsUtils.getModuleName(descriptor2) == null && !AnnotationsUtils.isNonModule(descriptor2)) {
            return;
        }
        if (descriptor2 instanceof PropertyDescriptor && ((PropertyDescriptor)descriptor2).isVar()) {
            diagnosticHolder.report(ErrorsJs.JS_MODULE_PROHIBITED_ON_VAR.on((KtElement)((PsiElement)declaration)));
        }
        if (!AnnotationsUtils.isNativeObject(descriptor2)) {
            diagnosticHolder.report(ErrorsJs.JS_MODULE_PROHIBITED_ON_NON_NATIVE.on((KtElement)((PsiElement)declaration)));
        }
        if (DescriptorUtils.isTopLevelDeclaration(descriptor2)) {
            boolean isFileModuleOrNonModule;
            boolean bl = isFileModuleOrNonModule = AnnotationsUtils.getFileModuleName(bindingContext, descriptor2) != null || AnnotationsUtils.isFromNonModuleFile(bindingContext, descriptor2);
            if (isFileModuleOrNonModule) {
                diagnosticHolder.report(ErrorsJs.NESTED_JS_MODULE_PROHIBITED.on((KtElement)((PsiElement)declaration)));
            }
        }
    }

    private final void checkSuperClass(BindingContext bindingContext, DiagnosticSink diagnosticHolder, DeclarationDescriptor descriptor2, KtDeclaration declaration) {
        Object v3;
        ClassDescriptor superClass;
        block4: {
            if (!(descriptor2 instanceof ClassDescriptor)) {
                return;
            }
            ClassDescriptor classDescriptor = DescriptorUtilsKt.getSuperClassNotAny((ClassDescriptor)descriptor2);
            if (classDescriptor == null) {
                return;
            }
            superClass = classDescriptor;
            KtDeclaration ktDeclaration = declaration;
            if (ktDeclaration == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtClassOrObject");
            }
            Iterable $receiver$iv = ((KtClassOrObject)ktDeclaration).getSuperTypeListEntries();
            for (Object element$iv : $receiver$iv) {
                KtSuperTypeListEntry entry = (KtSuperTypeListEntry)element$iv;
                Object object = (KotlinType)bindingContext.get(BindingContext.TYPE, entry.getTypeReference());
                if (!Intrinsics.areEqual(object != null && (object = ((KotlinType)object).getConstructor()) != null ? object.getDeclarationDescriptor() : null, superClass)) continue;
                v3 = element$iv;
                break block4;
            }
            v3 = null;
        }
        KtSuperTypeListEntry psi = v3;
        KtSuperTypeListEntry ktSuperTypeListEntry = psi;
        JsModuleCheckUtilKt.checkJsModuleUsage(bindingContext, diagnosticHolder, descriptor2, superClass, ktSuperTypeListEntry != null ? (PsiElement)ktSuperTypeListEntry : (PsiElement)declaration);
    }

    private JsModuleChecker() {
        INSTANCE = this;
    }

    static {
        new JsModuleChecker();
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder, @NotNull BindingContext bindingContext, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(diagnosticHolder, "diagnosticHolder");
        Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
        Intrinsics.checkParameterIsNotNull(languageVersionSettings, "languageVersionSettings");
        SimpleDeclarationChecker.DefaultImpls.check(this, declaration, descriptor2, diagnosticHolder, bindingContext, languageVersionSettings);
    }
}

