/*
 * Decompiled with CFR 0.152.
 */
package org.specs.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.specs.collection.JavaCollectionsConversion$;
import org.specs.io.FileSystem;
import org.specs.specification.Tag;
import org.specs.specification.Tagged;
import org.specs.specification.Tagged$class;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Queue;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class FileSystem$class {
    public static List filePaths(FileSystem $this, String path) {
        String pattern = $this.globToPattern(path);
        if ($this.isDir(path)) {
            pattern = new StringBuilder().append((Object)pattern).append((Object)"/*.*").toString();
        }
        Queue result2 = new Queue();
        FileSystem$class.org$specs$io$FileSystem$$collectFiles($this, result2, new File("."), pattern);
        return result2.toList();
    }

    public static final void org$specs$io$FileSystem$$collectFiles(FileSystem $this, Queue result$1, File file$1, String pattern$1) {
        $this.logger().debug((Function0<String>)new Serializable($this, file$1, pattern$1){
            public static final long serialVersionUID;
            private final File file$1;
            private final String pattern$1;

            static {
                long l2 = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)"try to accept ").append((Object)this.file$1.getPath().replace("\\", "/")).append((Object)" with ").append((Object)this.pattern$1).toString();
            }
            {
                this.file$1 = file2;
                this.pattern$1 = string;
            }
        });
        if (file$1.isFile() && file$1.getPath().replace("\\", "/").matches(pattern$1)) {
            $this.logger().debug((Function0<String>)new Serializable($this){
                public static final long serialVersionUID;

                static {
                    long l2 = serialVersionUID = 0L;
                }

                public final String apply() {
                    return "got a match";
                }
            });
            result$1.$plus$eq((Object)file$1.getPath());
        } else if (file$1.listFiles() != null) {
            Predef$.MODULE$.refArrayOps((Object[])file$1.listFiles()).foreach((Function1)new Serializable($this, result$1, pattern$1){
                public static final long serialVersionUID;
                private final FileSystem $outer;
                private final Queue result$1;
                private final String pattern$1;

                static {
                    long l2 = serialVersionUID = 0L;
                }

                public final void apply(File file2) {
                    FileSystem$class.org$specs$io$FileSystem$$collectFiles(this.$outer, this.result$1, file2, this.pattern$1);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.result$1 = queue;
                    this.pattern$1 = string;
                }
            });
        }
    }

    public static String globToPattern(FileSystem $this, String glob) {
        String star = "<STAR>";
        String authorizedNamePattern = new StringBuilder().append((Object)"[^\\/\\?<>\\|\\").append((Object)star).append((Object)":\"]").append((Object)star).toString();
        String pattern = glob.replace("\\", "/").replace(".", "\\.").replace("**/", new StringBuilder().append((Object)"(").append((Object)authorizedNamePattern).append((Object)"/)").append((Object)star).toString()).replace("*", authorizedNamePattern).replace(star, "*");
        if (!pattern.startsWith("\\./")) {
            pattern = new StringBuilder().append((Object)"\\./").append((Object)pattern).toString();
        }
        return pattern;
    }

    public static boolean isDir(FileSystem $this, String path) {
        return $this.isDirectory(path);
    }

    public static boolean createDir(FileSystem $this, String path) {
        return new File(path).mkdirs();
    }

    public static String removeDir(FileSystem $this, String path) {
        Object object;
        File dir = new File(path);
        if (dir.isDirectory()) {
            boolean bl;
            if (dir.listFiles() == null || Predef$.MODULE$.refArrayOps((Object[])dir.listFiles()).isEmpty()) {
                bl = dir.delete();
            } else {
                Predef$.MODULE$.refArrayOps((Object[])dir.listFiles()).foreach((Function1)new Serializable($this){
                    public static final long serialVersionUID;
                    private final FileSystem $outer;

                    static {
                        long l2 = serialVersionUID = 0L;
                    }

                    public final Object apply(File file2) {
                        return file2.isFile() ? BoxesRunTime.boxToBoolean((boolean)file2.delete()) : this.$outer.removeDir(file2.getPath());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                bl = dir.delete();
            }
            object = BoxesRunTime.boxToBoolean((boolean)bl);
        } else {
            object = BoxedUnit.UNIT;
        }
        return dir.getParent();
    }

    public static boolean exists(FileSystem $this, String path) {
        return path != null && new File(path).exists();
    }

    public static boolean canRead(FileSystem $this, String path) {
        return path != null && new File(path).canRead();
    }

    public static boolean canWrite(FileSystem $this, String path) {
        return path != null && new File(path).canWrite();
    }

    public static boolean isAbsolute(FileSystem $this, String path) {
        return path != null && new File(path).isAbsolute();
    }

    public static boolean isFile(FileSystem $this, String path) {
        return path != null && new File(path).isFile();
    }

    public static boolean isDirectory(FileSystem $this, String path) {
        return path != null && new File(path).isDirectory();
    }

    public static boolean isHidden(FileSystem $this, String path) {
        return path != null && new File(path).isHidden();
    }

    public static String getName(FileSystem $this, String path) {
        return new File(path).getName();
    }

    public static String getAbsolutePath(FileSystem $this, String path) {
        return new File(path).getAbsolutePath();
    }

    public static String getCanonicalPath(FileSystem $this, String path) {
        return new File(path).getCanonicalPath();
    }

    public static String getParent(FileSystem $this, String path) {
        return new File(path).getParent();
    }

    public static List listFiles(FileSystem $this, String path) {
        return new File(path).list() == null ? Nil$.MODULE$ : Predef$.MODULE$.refArrayOps((Object[])new File(path).list()).toList();
    }

    public static void copyDir(FileSystem $this, URL url, String dest) {
        $this.copyDir(new File(url.toURI()).getPath(), dest);
    }

    public static void copyDir(FileSystem $this, URL url, String dest, Tagged tagged) {
        $this.copyDir(new File(url.toURI()).getPath(), dest, tagged);
    }

    public static void copyDir(FileSystem $this, String src, String dest) {
        $this.copyDir(src, dest, new Tagged($this){
            private final Queue<Tag> tagList;
            private final Queue<Tag> accepted;
            private final Queue<Tag> rejected;

            public Queue<Tag> tagList() {
                return this.tagList;
            }

            public Queue<Tag> accepted() {
                return this.accepted;
            }

            public Queue<Tag> rejected() {
                return this.rejected;
            }

            public void org$specs$specification$Tagged$_setter_$tagList_$eq(Queue queue) {
                this.tagList = queue;
            }

            public void org$specs$specification$Tagged$_setter_$accepted_$eq(Queue queue) {
                this.accepted = queue;
            }

            public void org$specs$specification$Tagged$_setter_$rejected_$eq(Queue queue) {
                this.rejected = queue;
            }

            public Tag stringToTag(String s2) {
                return Tagged$class.stringToTag(this, s2);
            }

            public List<String> tagNames() {
                return Tagged$class.tagNames(this);
            }

            public Tagged tag(Seq<String> t2) {
                return Tagged$class.tag(this, t2);
            }

            public Tagged clearTags() {
                return Tagged$class.clearTags(this);
            }

            public Tagged addTag(String t2) {
                return Tagged$class.addTag(this, t2);
            }

            public Tagged addTags(Seq<String> t2) {
                return Tagged$class.addTags(this, t2);
            }

            public Tagged accept(Seq<Tag> t2) {
                return Tagged$class.accept(this, t2);
            }

            public Tagged acceptTag(Seq<String> s2) {
                return Tagged$class.acceptTag(this, s2);
            }

            public Tagged acceptTags(Seq<String> s2) {
                return Tagged$class.acceptTags(this, s2);
            }

            public Tagged acceptAnyTag() {
                return Tagged$class.acceptAnyTag(this);
            }

            public Tagged reject(Seq<Tag> t2) {
                return Tagged$class.reject(this, t2);
            }

            public Tagged rejectTag(Seq<String> s2) {
                return Tagged$class.rejectTag(this, s2);
            }

            public Tagged rejectTags(Seq<String> s2) {
                return Tagged$class.rejectTags(this, s2);
            }

            public boolean isAccepted() {
                return Tagged$class.isAccepted(this);
            }

            public String tagSpec() {
                return Tagged$class.tagSpec(this);
            }

            public Tagged tagWith(Tagged other) {
                return Tagged$class.tagWith(this, other);
            }

            public Seq<Tagged> taggedComponents() {
                return Tagged$class.taggedComponents(this);
            }

            public Object makeTagged(Seq<String> s2) {
                return Tagged$class.makeTagged(this, s2);
            }
            {
                Tagged$class.$init$(this);
            }
        });
    }

    public static void copyDir(FileSystem $this, String src$1, String dest$1, Tagged tagged$1) {
        $this.listFiles(src$1).foreach((Function1)new Serializable($this, src$1, dest$1, tagged$1){
            public static final long serialVersionUID;
            private final FileSystem $outer;
            private final String src$1;
            private final String dest$1;
            private final Tagged tagged$1;

            static {
                long l2 = serialVersionUID = 0L;
            }

            public final void apply(String name2) {
                if (this.tagged$1.makeTagged((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder().append((Object)this.src$1).append((Object)"/").append((Object)name2).toString()})).isAccepted()) {
                    this.$outer.copyFile(new StringBuilder().append((Object)this.src$1).append((Object)"/").append((Object)name2).toString(), this.dest$1);
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.src$1 = string;
                this.dest$1 = string2;
                this.tagged$1 = tagged;
            }
        });
    }

    public static void copyFile(FileSystem $this, String path, String dest) {
        $this.mkdirs(dest);
        String destFilePath = new StringBuilder().append((Object)dest).append((Object)"/").append((Object)new File(path).getName()).toString();
        new File(destFilePath).createNewFile();
        BufferedInputStream input = new BufferedInputStream(new FileInputStream(path));
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(destFilePath), 2048);
        $this.copy(input, output);
        output.flush();
        output.close();
        input.close();
    }

    public static void unjar(FileSystem $this, String path, String dest) {
        $this.unjar(path, dest, ".*");
    }

    public static void unjar(FileSystem $this, String path, String dirPath$1, String regexFilter$1) {
        $this.mkdirs(dirPath$1);
        FileInputStream fis = new FileInputStream(path);
        ZipInputStream zis$1 = new ZipInputStream(new BufferedInputStream(fis));
        Object entry = null;
        FileSystem$class.extractEntry$1($this, zis$1.getNextEntry(), dirPath$1, regexFilter$1, zis$1);
        zis$1.close();
    }

    public static void copy(FileSystem $this, InputStream input$1, OutputStream output$1) {
        byte[] data$1 = new byte[2048];
        FileSystem$class.readData$1($this, input$1.read(data$1, 0, 2048), input$1, output$1, data$1);
    }

    public static void copySpecResourcesDir(FileSystem $this, String src$2, String outputDir$1) {
        List<URL> dirUrls = $this.getResourcesNamed(src$2);
        ((IterableLike)Predef$.MODULE$.Set().apply((Seq)dirUrls.toList())).foreach((Function1)new Serializable($this, src$2, outputDir$1){
            public static final long serialVersionUID;
            private final FileSystem $outer;
            private final String src$2;
            private final String outputDir$1;

            static {
                long l2 = serialVersionUID = 0L;
            }

            public final void apply(URL dirUrl) {
                if (dirUrl.toString().startsWith("jar")) {
                    if (dirUrl.toString().toLowerCase().contains("specs")) {
                        this.$outer.unjar(Predef$.MODULE$.augmentString((String)Predef$.MODULE$.augmentString(FileSystem$class.org$specs$io$FileSystem$$getPath(this.$outer, dirUrl)).takeWhile((Function1)new Serializable(this){
                            public static final long serialVersionUID;

                            static {
                                long l2 = serialVersionUID = 0L;
                            }

                            public final boolean apply(char c2) {
                                return c2 != '!';
                            }
                        })).mkString(), this.outputDir$1, new StringBuilder().append((Object)".*").append((Object)this.src$2).append((Object)"/.*").toString());
                    }
                } else {
                    this.$outer.copyDir(dirUrl, new StringBuilder().append((Object)this.outputDir$1).append((Object)this.src$2).toString(), new Tagged(this){
                        private final Queue<Tag> tagList;
                        private final Queue<Tag> accepted;
                        private final Queue<Tag> rejected;

                        public Queue<Tag> tagList() {
                            return this.tagList;
                        }

                        public Queue<Tag> accepted() {
                            return this.accepted;
                        }

                        public Queue<Tag> rejected() {
                            return this.rejected;
                        }

                        public void org$specs$specification$Tagged$_setter_$tagList_$eq(Queue queue) {
                            this.tagList = queue;
                        }

                        public void org$specs$specification$Tagged$_setter_$accepted_$eq(Queue queue) {
                            this.accepted = queue;
                        }

                        public void org$specs$specification$Tagged$_setter_$rejected_$eq(Queue queue) {
                            this.rejected = queue;
                        }

                        public Tag stringToTag(String s2) {
                            return Tagged$class.stringToTag(this, s2);
                        }

                        public List<String> tagNames() {
                            return Tagged$class.tagNames(this);
                        }

                        public Tagged tag(Seq<String> t2) {
                            return Tagged$class.tag(this, t2);
                        }

                        public Tagged clearTags() {
                            return Tagged$class.clearTags(this);
                        }

                        public Tagged addTag(String t2) {
                            return Tagged$class.addTag(this, t2);
                        }

                        public Tagged addTags(Seq<String> t2) {
                            return Tagged$class.addTags(this, t2);
                        }

                        public Tagged accept(Seq<Tag> t2) {
                            return Tagged$class.accept(this, t2);
                        }

                        public Tagged acceptTag(Seq<String> s2) {
                            return Tagged$class.acceptTag(this, s2);
                        }

                        public Tagged acceptTags(Seq<String> s2) {
                            return Tagged$class.acceptTags(this, s2);
                        }

                        public Tagged acceptAnyTag() {
                            return Tagged$class.acceptAnyTag(this);
                        }

                        public Tagged reject(Seq<Tag> t2) {
                            return Tagged$class.reject(this, t2);
                        }

                        public Tagged rejectTag(Seq<String> s2) {
                            return Tagged$class.rejectTag(this, s2);
                        }

                        public Tagged rejectTags(Seq<String> s2) {
                            return Tagged$class.rejectTags(this, s2);
                        }

                        public boolean isAccepted() {
                            return Tagged$class.isAccepted(this);
                        }

                        public String tagSpec() {
                            return Tagged$class.tagSpec(this);
                        }

                        public Tagged tagWith(Tagged other) {
                            return Tagged$class.tagWith(this, other);
                        }

                        public Seq<Tagged> taggedComponents() {
                            return Tagged$class.taggedComponents(this);
                        }

                        public Object makeTagged(Seq<String> s2) {
                            return Tagged$class.makeTagged(this, s2);
                        }
                        {
                            Tagged$class.$init$(this);
                        }
                    }.accept((Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[]{new Tag(".*")})).reject((Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[]{new Tag(".*\\.svn.*"), new Tag(".*CVS.*")})));
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.src$2 = string;
                this.outputDir$1 = string2;
            }
        });
    }

    public static final String org$specs$io$FileSystem$$getPath(FileSystem $this, URL url) {
        String string = System.getProperty("file.separator");
        String string2 = "\\";
        return !(string != null ? !string.equals(string2) : string2 != null) ? url.getPath().replace("\\", "/").replace("file:/", "") : url.getPath().replace("file:", "");
    }

    public static List getResourcesNamed(FileSystem $this, String name2) {
        List list;
        URL resource = ClassLoader.getSystemResource(name2);
        Enumeration<URL> resources = $this.getClass().getClassLoader().getResources(name2);
        if (resource == null) {
            list = JavaCollectionsConversion$.MODULE$.enumerationToList(resources);
        } else {
            URL uRL = resource;
            list = JavaCollectionsConversion$.MODULE$.enumerationToList(resources).$colon$colon((Object)uRL);
        }
        return list;
    }

    private static final void extractEntry$1(FileSystem $this, ZipEntry entry, String string, String string2, ZipInputStream zipInputStream) {
        while (entry != null) {
            Object object;
            if (entry.getName().matches(string2)) {
                if (entry.isDirectory()) {
                    object = BoxesRunTime.boxToBoolean((boolean)$this.createDir(new StringBuilder().append((Object)string).append((Object)"/").append((Object)entry.getName()).toString()));
                } else {
                    $this.createFile(new StringBuilder().append((Object)string).append((Object)"/").append((Object)entry.getName()).toString());
                    FileOutputStream fos = new FileOutputStream(new StringBuilder().append((Object)string).append((Object)"/").append((Object)entry.getName()).toString());
                    BufferedOutputStream dest = new BufferedOutputStream(fos, 2048);
                    $this.copy(zipInputStream, dest);
                    dest.flush();
                    dest.close();
                    object = BoxedUnit.UNIT;
                }
            } else {
                object = BoxedUnit.UNIT;
            }
            entry = zipInputStream.getNextEntry();
        }
        return;
    }

    private static final void readData$1(FileSystem $this, int count, InputStream inputStream, OutputStream outputStream, byte[] byArray) {
        while (count != -1) {
            outputStream.write(byArray, 0, count);
            outputStream.flush();
            count = inputStream.read(byArray, 0, 2048);
        }
    }

    public static void $init$(FileSystem $this) {
    }
}

