/*
 * Decompiled with CFR 0.152.
 */
package org.specs.io.mock;

import java.io.InputStream;
import java.io.StringReader;
import org.specs.io.mock.MockFileSystem;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class MockFileSystem$class {
    public static String readFile(MockFileSystem $this, String path) {
        return (String)$this.files().apply((Object)path);
    }

    public static List filePaths(MockFileSystem $this, String path) {
        return $this.files().keySet().toList();
    }

    public static void addFile(MockFileSystem $this, String content) {
        $this.addFile($this.defaultFilePath(), content);
    }

    public static void addFile(MockFileSystem $this, String path, String content) {
        $this.files().$plus$eq(Predef.Pair$.MODULE$.apply((Object)path, (Object)content));
        $this.readableFiles_$eq((List<String>)$this.readableFiles().$colon$colon((Object)path));
        $this.writableFiles_$eq((List<String>)$this.writableFiles().$colon$colon((Object)path));
    }

    public static void addChild(MockFileSystem $this, String parent2, String child) {
        Option option;
        block4: {
            block3: {
                BoxedUnit boxedUnit;
                block2: {
                    option = $this.children().get((Object)parent2);
                    if (!(option instanceof Some)) break block2;
                    boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                boxedUnit = $this.children().put((Object)parent2, (Object)new ListBuffer());
            }
            ((ListBuffer)$this.children().get((Object)parent2).get()).$plus$eq((Object)child);
            return;
        }
        throw new MatchError((Object)option);
    }

    public static void setReadable(MockFileSystem $this, String path) {
        if (!$this.canRead(path)) {
            $this.readableFiles_$eq((List<String>)$this.readableFiles().$colon$colon((Object)path));
        }
    }

    public static void setWritable(MockFileSystem $this, String path) {
        if (!$this.canWrite(path)) {
            $this.writableFiles_$eq((List<String>)$this.writableFiles().$colon$colon((Object)path));
        }
    }

    public static void setNotReadable(MockFileSystem $this, String path$4) {
        $this.readableFiles_$eq((List<String>)((List)$this.readableFiles().filterNot((Function1)new Serializable($this, path$4){
            public static final long serialVersionUID;
            private final String path$4;

            static {
                long l2 = serialVersionUID = 0L;
            }

            public final boolean apply(String string) {
                String string2 = string;
                String string3 = this.path$4;
                return !(string2 != null ? !string2.equals(string3) : string3 != null);
            }
            {
                this.path$4 = string;
            }
        })));
    }

    public static void setNotWritable(MockFileSystem $this, String path$5) {
        $this.writableFiles_$eq((List<String>)((List)$this.writableFiles().filterNot((Function1)new Serializable($this, path$5){
            public static final long serialVersionUID;
            private final String path$5;

            static {
                long l2 = serialVersionUID = 0L;
            }

            public final boolean apply(String string) {
                String string2 = string;
                String string3 = this.path$5;
                return !(string2 != null ? !string2.equals(string3) : string3 != null);
            }
            {
                this.path$5 = string;
            }
        })));
    }

    public static boolean canRead(MockFileSystem $this, String path$2) {
        return $this.readableFiles().exists((Function1)new Serializable($this, path$2){
            public static final long serialVersionUID;
            private final String path$2;

            static {
                long l2 = serialVersionUID = 0L;
            }

            public final boolean apply(String string) {
                String string2 = string;
                String string3 = this.path$2;
                return !(string2 != null ? !string2.equals(string3) : string3 != null);
            }
            {
                this.path$2 = string;
            }
        });
    }

    public static boolean canWrite(MockFileSystem $this, String path$3) {
        return $this.writableFiles().exists((Function1)new Serializable($this, path$3){
            public static final long serialVersionUID;
            private final String path$3;

            static {
                long l2 = serialVersionUID = 0L;
            }

            public final boolean apply(String string) {
                String string2 = string;
                String string3 = this.path$3;
                return !(string2 != null ? !string2.equals(string3) : string3 != null);
            }
            {
                this.path$3 = string;
            }
        });
    }

    public static boolean isAbsolute(MockFileSystem $this, String path) {
        return path.startsWith("/") || path.startsWith("\\");
    }

    public static boolean isHidden(MockFileSystem $this, String path) {
        return path.startsWith(".");
    }

    public static boolean isFile(MockFileSystem $this, String path) {
        return path.matches(".*\\..*");
    }

    public static boolean isDirectory(MockFileSystem $this, String path) {
        return !$this.isFile(path);
    }

    public static List listFiles(MockFileSystem $this, String path) {
        return (List)$this.children().get((Object)path.replaceAll("\\\\", "/")).map((Function1)new Serializable($this){
            public static final long serialVersionUID;

            static {
                long l2 = serialVersionUID = 0L;
            }

            public final List<String> apply(ListBuffer<String> listBuffer) {
                return listBuffer.toList();
            }
        }).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID;

            static {
                long l2 = serialVersionUID = 0L;
            }

            public final List<String> apply() {
                return Nil$.MODULE$;
            }
        });
    }

    public static String defaultFilePath(MockFileSystem $this) {
        return new StringBuilder().append((Object)"name").append((Object)BoxesRunTime.boxToInteger((int)$this.files().size())).append((Object)$this.defaultExtension()).toString();
    }

    public static boolean createFile(MockFileSystem $this, String path) {
        $this.files().$plus$eq(Predef$.MODULE$.any2ArrowAssoc((Object)path).$minus$greater((Object)""));
        return true;
    }

    public static boolean mkdirs(MockFileSystem $this, String path) {
        String string = path;
        $this.createdDirs_$eq((List<String>)$this.createdDirs().$colon$colon((Object)string));
        return true;
    }

    public static boolean createDir(MockFileSystem $this, String path) {
        return $this.mkdirs(path);
    }

    public static MockFileSystem.MockFileWriter getWriter(MockFileSystem $this, String path) {
        return new MockFileSystem.MockFileWriter($this, path);
    }

    public static MockFileSystem reset(MockFileSystem $this) {
        $this.files_$eq((HashMap<String, String>)new HashMap());
        $this.children_$eq((HashMap<String, ListBuffer<String>>)new HashMap());
        $this.readableFiles_$eq((List<String>)Nil$.MODULE$);
        $this.writableFiles_$eq((List<String>)Nil$.MODULE$);
        return $this;
    }

    public static boolean exists(MockFileSystem $this, String path) {
        return $this.files().contains((Object)path);
    }

    public static InputStream inputStream(MockFileSystem $this, String filePath$1) {
        return new InputStream($this, filePath$1){
            private final StringReader reader;

            private StringReader reader() {
                return this.reader;
            }

            public int read() {
                return this.reader().read();
            }
            {
                this.reader = new StringReader($outer.readFile(string));
            }
        };
    }

    public static void $init$(MockFileSystem $this) {
        $this.defaultExtension_$eq("");
        $this.files_$eq((HashMap<String, String>)new HashMap());
        $this.createdDirs_$eq((List<String>)Nil$.MODULE$);
        $this.children_$eq((HashMap<String, ListBuffer<String>>)new HashMap());
        $this.readableFiles_$eq((List<String>)Nil$.MODULE$);
        $this.writableFiles_$eq((List<String>)Nil$.MODULE$);
    }
}

