/*
 * Decompiled with CFR 0.152.
 */
package scalaj.http;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.xml.Elem;
import scala.xml.XML$;
import scalaj.http.Base64;
import scalaj.http.Http;
import scalaj.http.Http$;
import scalaj.http.Http$Request$;
import scalaj.http.HttpOptions$;
import scalaj.http.MultiPart;
import scalaj.http.Token;

public final class Http$ {
    public static final Http$ MODULE$;
    private final List<Function1<HttpURLConnection, BoxedUnit>> defaultOptions;
    private final String CrLf;
    private final String Pref;
    private final String Boundary;
    private final String ContentDisposition;
    private final String Filename;
    private final String ContentType;
    private final Function2<HttpURLConnection, Object, BoxedUnit> setFixedLengthStreamingMode;
    private final String utf8;

    static {
        new Http$();
    }

    public Http.Request apply(String url) {
        return this.get(url);
    }

    public <E> E tryParse(InputStream is, Function1<InputStream, E> parser) {
        try {
            return (E)parser.apply((Object)is);
        }
        finally {
            is.close();
        }
    }

    public String readString(InputStream is) {
        return this.readString(is, this.utf8());
    }

    public String readString(InputStream is, String charset) {
        InputStreamReader in = new InputStreamReader(is, charset);
        StringBuilder bos = new StringBuilder();
        char[] ba = new char[4096];
        this.readOnce$1(in, bos, ba);
        return bos.toString();
    }

    public byte[] readBytes(InputStream in) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] ba = new byte[4096];
        this.readOnce$2(in, bos, ba);
        return bos.toByteArray();
    }

    public Elem readXml(InputStream in) {
        return (Elem)XML$.MODULE$.load(in);
    }

    public List<Tuple2<String, String>> readParams(InputStream in, String charset) {
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.readString(in, charset).split("&")).flatMap((Function1)new Serializable(charset){
            public static final long serialVersionUID = 0L;
            private final String charset$1;

            public final Iterable<Tuple2<String, String>> apply(String x$13) {
                Iterable iterable;
                String[] stringArray = x$13.split("=");
                Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
                if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
                    String k = (String)((SeqLike)option.get()).apply(0);
                    String v = (String)((SeqLike)option.get()).apply(1);
                    iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)new Tuple2((Object)Http$.MODULE$.urlDecode(k, this.charset$1), (Object)Http$.MODULE$.urlDecode(v, this.charset$1))));
                } else {
                    iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
                return iterable;
            }
            {
                this.charset$1 = charset$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toList();
    }

    public String readParams$default$2() {
        return this.utf8();
    }

    public Map<String, String> readParamMap(InputStream in, String charset) {
        return (Map)Predef$.MODULE$.Map().apply(this.readParams(in, charset));
    }

    public String readParamMap$default$2() {
        return this.utf8();
    }

    public Token readToken(InputStream in) {
        Map<String, String> params = this.readParamMap(in, this.readParamMap$default$2());
        return new Token((String)params.apply((Object)"oauth_token"), (String)params.apply((Object)"oauth_token_secret"));
    }

    public List<Function1<HttpURLConnection, BoxedUnit>> defaultOptions() {
        return this.defaultOptions;
    }

    public String urlEncode(String name, String charset) {
        return URLEncoder.encode(name, charset);
    }

    public String urlDecode(String name, String charset) {
        return URLDecoder.decode(name, charset);
    }

    public String base64(byte[] bytes) {
        return new String(Base64.encode(bytes));
    }

    public String base64(String in) {
        return this.base64(in.getBytes(this.utf8()));
    }

    public String toQs(List<Tuple2<String, String>> params, String charset) {
        return ((TraversableOnce)params.map((Function1)new Serializable(charset){
            public static final long serialVersionUID = 0L;
            private final String charset$2;

            public final String apply(Tuple2<String, String> p) {
                return new StringBuilder().append((Object)Http$.MODULE$.urlEncode((String)p._1(), this.charset$2)).append((Object)"=").append((Object)Http$.MODULE$.urlEncode((String)p._2(), this.charset$2)).toString();
            }
            {
                this.charset$2 = charset$2;
            }
        }, List$.MODULE$.canBuildFrom())).mkString("&");
    }

    public String appendQs(String url, List<Tuple2<String, String>> params, String charset) {
        return new StringBuilder().append((Object)url).append((Object)(params.isEmpty() ? "" : new StringBuilder().append((Object)(url.contains("?") ? "&" : "?")).append((Object)this.toQs(params, charset)).toString())).toString();
    }

    public Function1<Http.Request, URL> appendQsHttpUrl(String url) {
        return new Serializable(url){
            public static final long serialVersionUID = 0L;
            private final String url$1;

            public final URL apply(Http.Request r) {
                return new URL(Http$.MODULE$.appendQs(this.url$1, r.params(), r.charset()));
            }
            {
                this.url$1 = url$1;
            }
        };
    }

    public Function1<Http.Request, URL> noopHttpUrl(String url) {
        return new Serializable(url){
            public static final long serialVersionUID = 0L;
            private final String url$2;

            public final URL apply(Http.Request r) {
                return new URL(this.url$2);
            }
            {
                this.url$2 = url$2;
            }
        };
    }

    public Http.Request get(String url) {
        Serializable getFunc = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Http.Request req, HttpURLConnection conn) {
                conn.connect();
            }
        };
        return Http$Request$.MODULE$.apply((Function2<Http.Request, HttpURLConnection, BoxedUnit>)getFunc, this.appendQsHttpUrl(url), "GET");
    }

    public String CrLf() {
        return this.CrLf;
    }

    public String Pref() {
        return this.Pref;
    }

    public String Boundary() {
        return this.Boundary;
    }

    public String ContentDisposition() {
        return this.ContentDisposition;
    }

    public String Filename() {
        return this.Filename;
    }

    public String ContentType() {
        return this.ContentType;
    }

    public Function2<HttpURLConnection, Object, BoxedUnit> setFixedLengthStreamingMode() {
        return this.setFixedLengthStreamingMode;
    }

    public Http.Request multipart(String url, Seq<MultiPart> parts) {
        Serializable postFunc = new Serializable(parts){
            public static final long serialVersionUID = 0L;
            private final Seq parts$1;

            public final void apply(Http.Request req, HttpURLConnection conn) {
                conn.setDoOutput(true);
                conn.setDoInput(true);
                conn.setUseCaches(false);
                conn.setRequestMethod("POST");
                conn.setRequestProperty("Content-Type", new StringBuilder().append((Object)"multipart/form-data; boundary=").append((Object)Http$.MODULE$.Boundary()).toString());
                conn.setRequestProperty("MIME-Version", "1.0");
                List paramBytes = (List)req.params().map((Function1)new Serializable(this, req){
                    public static final long serialVersionUID = 0L;
                    private final Http.Request req$1;

                    public final Tuple2<byte[], byte[]> apply(Tuple2<String, String> p) {
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)((String)p._1()).getBytes(this.req$1.charset())), (Object)((String)p._2()).getBytes(this.req$1.charset()));
                    }
                    {
                        this.req$1 = req$1;
                    }
                }, List$.MODULE$.canBuildFrom());
                Seq partBytes = (Seq)this.parts$1.map((Function1)new Serializable(this, req){
                    public static final long serialVersionUID = 0L;
                    private final Http.Request req$1;

                    public final Tuple3<byte[], byte[], MultiPart> apply(MultiPart p) {
                        return new Tuple3((Object)p.name().getBytes(this.req$1.charset()), (Object)p.filename().getBytes(this.req$1.charset()), (Object)p);
                    }
                    {
                        this.req$1 = req$1;
                    }
                }, Seq$.MODULE$.canBuildFrom());
                int paramOverhead = Http$.MODULE$.Pref().length() + Http$.MODULE$.Boundary().length() + Http$.MODULE$.ContentDisposition().length() + 1 + Http$.MODULE$.CrLf().length() * 4;
                int paramsLength = BoxesRunTime.unboxToInt((Object)((TraversableOnce)paramBytes.map((Function1)new Serializable(this, paramOverhead){
                    public static final long serialVersionUID = 0L;
                    private final int paramOverhead$1;

                    public final int apply(Tuple2<byte[], byte[]> p) {
                        return ((byte[])p._1()).length + ((byte[])p._2()).length + this.paramOverhead$1;
                    }
                    {
                        this.paramOverhead$1 = paramOverhead$1;
                    }
                }, List$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
                int fileOverhead = Http$.MODULE$.Pref().length() + Http$.MODULE$.Boundary().length() + Http$.MODULE$.ContentDisposition().length() + Http$.MODULE$.Filename().length() + 1 + Http$.MODULE$.CrLf().length() * 5 + Http$.MODULE$.ContentType().length();
                long filesLength = BoxesRunTime.unboxToLong((Object)((TraversableOnce)partBytes.map((Function1)new Serializable(this, fileOverhead){
                    public static final long serialVersionUID = 0L;
                    private final int fileOverhead$1;

                    public final long apply(Tuple3<byte[], byte[], MultiPart> p) {
                        return (long)(this.fileOverhead$1 + ((byte[])p._1()).length + ((byte[])p._2()).length + ((MultiPart)p._3()).mime().length()) + ((MultiPart)p._3()).numBytes();
                    }
                    {
                        this.fileOverhead$1 = fileOverhead$1;
                    }
                }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                int finaleBoundaryLength = Http$.MODULE$.Pref().length() * 2 + Http$.MODULE$.Boundary().length() + Http$.MODULE$.CrLf().length();
                long totalBytesToSend = (long)paramsLength + filesLength + (long)finaleBoundaryLength;
                Http$.MODULE$.setFixedLengthStreamingMode().apply((Object)conn, (Object)BoxesRunTime.boxToLong((long)totalBytesToSend));
                OutputStream out = conn.getOutputStream();
                paramBytes.foreach((Function1)new Serializable(this, out){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.3 $outer;
                    private final OutputStream out$1;

                    public final void apply(Tuple2<byte[], byte[]> x0$3) {
                        Tuple2<byte[], byte[]> tuple2 = x0$3;
                        if (tuple2 != null) {
                            byte[] name = (byte[])tuple2._1();
                            byte[] value = (byte[])tuple2._2();
                            this.$outer.scalaj$http$Http$$anonfun$$writeBytes$1(new StringBuilder().append((Object)Http$.MODULE$.Pref()).append((Object)Http$.MODULE$.Boundary()).append((Object)Http$.MODULE$.CrLf()).toString(), this.out$1);
                            this.$outer.scalaj$http$Http$$anonfun$$writeBytes$1(Http$.MODULE$.ContentDisposition(), this.out$1);
                            this.out$1.write(name);
                            this.$outer.scalaj$http$Http$$anonfun$$writeBytes$1(new StringBuilder().append((Object)"\"").append((Object)Http$.MODULE$.CrLf()).toString(), this.out$1);
                            this.$outer.scalaj$http$Http$$anonfun$$writeBytes$1(Http$.MODULE$.CrLf(), this.out$1);
                            this.out$1.write(value);
                            this.$outer.scalaj$http$Http$$anonfun$$writeBytes$1(Http$.MODULE$.CrLf(), this.out$1);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.out$1 = out$1;
                    }
                });
                byte[] buffer = new byte[req.sendBufferSize()];
                partBytes.foreach((Function1)new Serializable(this, out, buffer){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.3 $outer;
                    private final OutputStream out$1;
                    private final byte[] buffer$1;

                    public final void apply(Tuple3<byte[], byte[], MultiPart> x0$4) {
                        Tuple3<byte[], byte[], MultiPart> tuple3 = x0$4;
                        if (tuple3 != null) {
                            byte[] name = (byte[])tuple3._1();
                            byte[] filename = (byte[])tuple3._2();
                            MultiPart part = (MultiPart)tuple3._3();
                            this.$outer.scalaj$http$Http$$anonfun$$writeBytes$1(new StringBuilder().append((Object)Http$.MODULE$.Pref()).append((Object)Http$.MODULE$.Boundary()).append((Object)Http$.MODULE$.CrLf()).toString(), this.out$1);
                            this.$outer.scalaj$http$Http$$anonfun$$writeBytes$1(Http$.MODULE$.ContentDisposition(), this.out$1);
                            this.out$1.write(name);
                            this.$outer.scalaj$http$Http$$anonfun$$writeBytes$1(Http$.MODULE$.Filename(), this.out$1);
                            this.out$1.write(filename);
                            this.$outer.scalaj$http$Http$$anonfun$$writeBytes$1(new StringBuilder().append((Object)"\"").append((Object)Http$.MODULE$.CrLf()).toString(), this.out$1);
                            this.$outer.scalaj$http$Http$$anonfun$$writeBytes$1(new StringBuilder().append((Object)Http$.MODULE$.ContentType()).append((Object)part.mime()).append((Object)Http$.MODULE$.CrLf()).append((Object)Http$.MODULE$.CrLf()).toString(), this.out$1);
                            IntRef bytesWritten = new IntRef(0);
                            this.readOnce$3(part, bytesWritten);
                            this.$outer.scalaj$http$Http$$anonfun$$writeBytes$1(Http$.MODULE$.CrLf(), this.out$1);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple3);
                    }

                    private final void readOnce$3(MultiPart part$1, IntRef bytesWritten$1) {
                        int len;
                        do {
                            if ((len = part$1.data().read(this.buffer$1)) <= 0) continue;
                            this.out$1.write(this.buffer$1, 0, len);
                            bytesWritten$1.elem += len;
                            part$1.writeCallBack().apply$mcVJ$sp((long)bytesWritten$1.elem);
                        } while (len >= 0);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.out$1 = out$1;
                        this.buffer$1 = buffer$1;
                    }
                });
                this.scalaj$http$Http$$anonfun$$writeBytes$1(new StringBuilder().append((Object)Http$.MODULE$.Pref()).append((Object)Http$.MODULE$.Boundary()).append((Object)Http$.MODULE$.Pref()).append((Object)Http$.MODULE$.CrLf()).toString(), out);
                out.flush();
                out.close();
            }

            public final void scalaj$http$Http$$anonfun$$writeBytes$1(String s, OutputStream out$1) {
                out$1.write(s.getBytes(Http$.MODULE$.utf8()));
            }
            {
                this.parts$1 = parts$1;
            }
        };
        return Http$Request$.MODULE$.apply((Function2<Http.Request, HttpURLConnection, BoxedUnit>)postFunc, this.noopHttpUrl(url), "POST");
    }

    public Http.Request postData(String url, String data) {
        return this.postData(url, data.getBytes(this.utf8()));
    }

    public Http.Request postData(String url, byte[] data) {
        Serializable postFunc = new Serializable(data){
            public static final long serialVersionUID = 0L;
            private final byte[] data$1;

            public final void apply(Http.Request req, HttpURLConnection conn) {
                conn.setDoOutput(true);
                conn.connect();
                conn.getOutputStream().write(this.data$1);
            }
            {
                this.data$1 = data$1;
            }
        };
        return Http$Request$.MODULE$.apply((Function2<Http.Request, HttpURLConnection, BoxedUnit>)postFunc, this.noopHttpUrl(url), "POST");
    }

    public Http.Request post(String url) {
        Serializable postFunc = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Http.Request req, HttpURLConnection conn) {
                conn.setDoOutput(true);
                conn.connect();
                conn.getOutputStream().write(Http$.MODULE$.toQs(req.params(), req.charset()).getBytes(req.charset()));
            }
        };
        return Http$Request$.MODULE$.apply((Function2<Http.Request, HttpURLConnection, BoxedUnit>)postFunc, this.noopHttpUrl(url), "POST").header("content-type", "application/x-www-form-urlencoded");
    }

    public String utf8() {
        return this.utf8;
    }

    private final void readOnce$1(InputStreamReader in$2, StringBuilder bos$1, char[] ba$1) {
        int len;
        do {
            Object object = (len = in$2.read(ba$1)) > 0 ? bos$1.appendAll(ba$1, 0, len) : BoxedUnit.UNIT;
        } while (len >= 0);
    }

    private final void readOnce$2(InputStream in$1, ByteArrayOutputStream bos$2, byte[] ba$2) {
        int len;
        do {
            if ((len = in$1.read(ba$2)) <= 0) continue;
            bos$2.write(ba$2, 0, len);
        } while (len >= 0);
    }

    private final Tuple2 liftedTree1$1(Class connClass$1) {
        Tuple2 tuple2;
        try {
            tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToBoolean((boolean)true)), (Object)connClass$1.getDeclaredMethod("setFixedLengthStreamingMode", Long.TYPE));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToBoolean((boolean)false)), (Object)connClass$1.getDeclaredMethod("setFixedLengthStreamingMode", Integer.TYPE));
        }
        return tuple2;
    }

    private Http$() {
        MODULE$ = this;
        this.defaultOptions = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{HttpOptions$.MODULE$.connTimeout(100), HttpOptions$.MODULE$.readTimeout(500)}));
        this.CrLf = "\r\n";
        this.Pref = "--";
        this.Boundary = "--gc0pMUlT1B0uNdArYc0p";
        this.ContentDisposition = "Content-Disposition: form-data; name=\"";
        this.Filename = "\"; filename=\"";
        this.ContentType = "Content-Type: ";
        Class<HttpURLConnection> connClass = HttpURLConnection.class;
        Tuple2 tuple2 = this.liftedTree1$1(connClass);
        if (tuple2 != null) {
            Tuple2 tuple22;
            boolean isLong = tuple2._1$mcZ$sp();
            Method theMethod = (Method)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)isLong), (Object)theMethod);
            boolean isLong2 = tuple23._1$mcZ$sp();
            Method theMethod2 = (Method)tuple23._2();
            this.setFixedLengthStreamingMode = new anonfun.2(isLong2, theMethod2);
            this.utf8 = "UTF-8";
            return;
        }
        throw new MatchError((Object)tuple2);
    }
}

