/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.commons.lang;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public final class BufferString
implements Comparable<BufferString> {
    int start;
    int length = 0;
    byte[] buf;
    int hash;

    public BufferString(byte[] buf, int start, int length) {
        this.start = start;
        this.buf = buf;
        this.length = start + length > buf.length - 1 ? buf.length - start : length;
    }

    public void appendToBuffer(byte[] buffer, int start) {
        for (int i = 0; i < this.length; ++i) {
            buffer[start + i] = this.buf[this.start + i];
        }
    }

    public byte byteAt(int pos) {
        return this.buf[this.start + pos];
    }

    private boolean equalsBufferString(BufferString myString) {
        if (this.hashCode() != myString.hashCode()) {
            return false;
        }
        for (int i = 0; i < this.length; ++i) {
            if (this.buf[this.start + i] == myString.buf[myString.start + i]) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof BufferString) {
            BufferString string = (BufferString)object;
            return this.equalsBufferString(string);
        }
        return false;
    }

    public int length() {
        return this.length;
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0 && this.length > 0) {
            int off = this.start;
            int len = this.length;
            for (int i = 0; i < len; ++i) {
                h = 31 * h + this.buf[off++];
            }
            this.hash = h;
        }
        return h;
    }

    public String toString() {
        return this.toString("GBK");
    }

    public String toString(String ... encoding) {
        try {
            return new String(this.buf, this.start, this.length, encoding[0]);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public int write(OutputStream out) throws IOException {
        out.write(this.buf, this.start, this.length);
        return this.length;
    }

    @Override
    public int compareTo(BufferString string) {
        for (int i = 0; i < this.length && i < string.length; ++i) {
            if (this.buf[this.start + i] > string.buf[string.start + i]) {
                return 1;
            }
            if (this.buf[this.start + i] >= string.buf[string.start + i]) continue;
            return -1;
        }
        if (this.length == string.length) {
            return 0;
        }
        if (this.length > string.length) {
            return 1;
        }
        return -1;
    }
}

