/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.commons.tools;

import java.util.List;

public class ArrayUtil {
    private static final Object[] EMPTY_ARRAY = new Object[0];

    public static int arrayLength(Object array) {
        return ArrayUtil.arrayLength(array, 0, 0);
    }

    private static int arrayLength(Object array, int defaultIfNull, int defaultIfNotArray) {
        if (array == null) {
            return defaultIfNull;
        }
        if (array instanceof Object[]) {
            return ((Object[])array).length;
        }
        if (array instanceof long[]) {
            return ((long[])array).length;
        }
        if (array instanceof int[]) {
            return ((int[])array).length;
        }
        if (array instanceof short[]) {
            return ((short[])array).length;
        }
        if (array instanceof byte[]) {
            return ((byte[])array).length;
        }
        if (array instanceof double[]) {
            return ((double[])array).length;
        }
        if (array instanceof float[]) {
            return ((float[])array).length;
        }
        if (array instanceof boolean[]) {
            return ((boolean[])array).length;
        }
        if (array instanceof char[]) {
            return ((char[])array).length;
        }
        return defaultIfNotArray;
    }

    public static boolean isEmptyArray(Object array) {
        return ArrayUtil.arrayLength(array, 0, -1) == 0;
    }

    public static <T, S extends T> T defaultIfEmptyArray(T array, S defaultValue) {
        return (T)(ArrayUtil.isEmptyArray(array) ? defaultValue : array);
    }

    public static boolean isArraySameLength(Object[] array1, Object[] array2) {
        int length1 = array1 == null ? 0 : array1.length;
        int length2 = array2 == null ? 0 : array2.length;
        return length1 == length2;
    }

    public static boolean isArraySameLength(long[] array1, long[] array2) {
        int length1 = array1 == null ? 0 : array1.length;
        int length2 = array2 == null ? 0 : array2.length;
        return length1 == length2;
    }

    public static boolean isArraySameLength(int[] array1, int[] array2) {
        int length1 = array1 == null ? 0 : array1.length;
        int length2 = array2 == null ? 0 : array2.length;
        return length1 == length2;
    }

    public static boolean isArraySameLength(short[] array1, short[] array2) {
        int length1 = array1 == null ? 0 : array1.length;
        int length2 = array2 == null ? 0 : array2.length;
        return length1 == length2;
    }

    public static boolean isArraySameLength(byte[] array1, byte[] array2) {
        int length1 = array1 == null ? 0 : array1.length;
        int length2 = array2 == null ? 0 : array2.length;
        return length1 == length2;
    }

    public static boolean isArraySameLength(double[] array1, double[] array2) {
        int length1 = array1 == null ? 0 : array1.length;
        int length2 = array2 == null ? 0 : array2.length;
        return length1 == length2;
    }

    public static boolean isArraySameLength(float[] array1, float[] array2) {
        int length1 = array1 == null ? 0 : array1.length;
        int length2 = array2 == null ? 0 : array2.length;
        return length1 == length2;
    }

    public static boolean isArraySameLength(boolean[] array1, boolean[] array2) {
        int length1 = array1 == null ? 0 : array1.length;
        int length2 = array2 == null ? 0 : array2.length;
        return length1 == length2;
    }

    public static boolean isArraySameLength(char[] array1, char[] array2) {
        int length1 = array1 == null ? 0 : array1.length;
        int length2 = array2 == null ? 0 : array2.length;
        return length1 == length2;
    }

    public static void arrayReverse(Object[] array) {
        if (array == null) {
            return;
        }
        int i = 0;
        for (int j = array.length - 1; j > i; ++i, --j) {
            Object tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    public static void arrayReverse(long[] array) {
        if (array == null) {
            return;
        }
        int i = 0;
        for (int j = array.length - 1; j > i; ++i, --j) {
            long tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    public static void arrayReverse(int[] array) {
        if (array == null) {
            return;
        }
        int i = 0;
        for (int j = array.length - 1; j > i; ++i, --j) {
            int tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    public static void arrayReverse(short[] array) {
        if (array == null) {
            return;
        }
        int i = 0;
        for (int j = array.length - 1; j > i; ++i, --j) {
            short tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    public static void arrayReverse(byte[] array) {
        if (array == null) {
            return;
        }
        int i = 0;
        for (int j = array.length - 1; j > i; ++i, --j) {
            byte tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    public static void arrayReverse(double[] array) {
        if (array == null) {
            return;
        }
        int i = 0;
        for (int j = array.length - 1; j > i; ++i, --j) {
            double tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    public static void arrayReverse(float[] array) {
        if (array == null) {
            return;
        }
        int i = 0;
        for (int j = array.length - 1; j > i; ++i, --j) {
            float tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    public static void arrayReverse(boolean[] array) {
        if (array == null) {
            return;
        }
        int i = 0;
        for (int j = array.length - 1; j > i; ++i, --j) {
            boolean tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    public static void arrayReverse(char[] array) {
        if (array == null) {
            return;
        }
        int i = 0;
        for (int j = array.length - 1; j > i; ++i, --j) {
            char tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    public static int arrayIndexOf(Object[] array, Object objectToFind) {
        return ArrayUtil.arrayIndexOf(array, objectToFind, 0);
    }

    public static int arrayIndexOf(Object[] array, Object[] arrayToFind) {
        return ArrayUtil.arrayIndexOf(array, arrayToFind, 0);
    }

    public static int arrayIndexOf(Object[] array, Object objectToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (objectToFind == null) {
            for (int i = startIndex; i < array.length; ++i) {
                if (array[i] != null) continue;
                return i;
            }
        } else {
            for (int i = startIndex; i < array.length; ++i) {
                if (!objectToFind.equals(array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static int arrayLastIndexOf(Object[] array, Object objectToFind) {
        return ArrayUtil.arrayLastIndexOf(array, objectToFind, Integer.MAX_VALUE);
    }

    public static int arrayLastIndexOf(Object[] array, Object[] arrayToFind) {
        return ArrayUtil.arrayLastIndexOf(array, arrayToFind, Integer.MAX_VALUE);
    }

    public static int arrayLastIndexOf(Object[] array, Object objectToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        if (objectToFind == null) {
            for (int i = startIndex; i >= 0; --i) {
                if (array[i] != null) continue;
                return i;
            }
        } else {
            for (int i = startIndex; i >= 0; --i) {
                if (!objectToFind.equals(array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static boolean arrayContains(Object[] array, Object objectToFind) {
        return ArrayUtil.arrayIndexOf(array, objectToFind) != -1;
    }

    public static boolean arrayContains(Object[] array, Object[] arrayToFind) {
        return ArrayUtil.arrayIndexOf(array, arrayToFind) != -1;
    }

    public static int arrayIndexOf(long[] array, long longToFind) {
        return ArrayUtil.arrayIndexOf(array, longToFind, 0);
    }

    public static int arrayIndexOf(long[] array, long[] arrayToFind) {
        return ArrayUtil.arrayIndexOf(array, arrayToFind, 0);
    }

    public static int arrayIndexOf(long[] array, long longToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        for (int i = startIndex; i < array.length; ++i) {
            if (longToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int arrayIndexOf(long[] array, long[] arrayToFind, int startIndex) {
        if (array == null || arrayToFind == null) {
            return -1;
        }
        int sourceLength = array.length;
        int targetLength = arrayToFind.length;
        if (startIndex >= sourceLength) {
            return targetLength == 0 ? sourceLength : -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (targetLength == 0) {
            return startIndex;
        }
        long first = arrayToFind[0];
        int i = startIndex;
        int max = sourceLength - targetLength;
        block0: while (true) {
            if (i <= max && array[i] != first) {
                ++i;
                continue;
            }
            if (i > max) {
                return -1;
            }
            int j = i + 1;
            int end = j + targetLength - 1;
            int k = 1;
            while (j < end) {
                if (array[j++] == arrayToFind[k++]) continue;
                ++i;
                continue block0;
            }
            break;
        }
        return i;
    }

    public static int arrayLastIndexOf(long[] array, long longToFind) {
        return ArrayUtil.arrayLastIndexOf(array, longToFind, Integer.MAX_VALUE);
    }

    public static int arrayLastIndexOf(long[] array, long[] arrayToFind) {
        return ArrayUtil.arrayLastIndexOf(array, arrayToFind, Integer.MAX_VALUE);
    }

    public static int arrayLastIndexOf(long[] array, long longToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        for (int i = startIndex; i >= 0; --i) {
            if (longToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int arrayLastIndexOf(long[] array, long[] arrayToFind, int startIndex) {
        int start;
        if (array == null || arrayToFind == null) {
            return -1;
        }
        int sourceLength = array.length;
        int targetLength = arrayToFind.length;
        int rightIndex = sourceLength - targetLength;
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex > rightIndex) {
            startIndex = rightIndex;
        }
        if (targetLength == 0) {
            return startIndex;
        }
        int lastIndex = targetLength - 1;
        long last = arrayToFind[lastIndex];
        int min = targetLength - 1;
        int i = min + startIndex;
        block0: while (true) {
            if (i >= min && array[i] != last) {
                --i;
                continue;
            }
            if (i < min) {
                return -1;
            }
            int j = i - 1;
            start = j - (targetLength - 1);
            int k = lastIndex - 1;
            while (j > start) {
                if (array[j--] == arrayToFind[k--]) continue;
                --i;
                continue block0;
            }
            break;
        }
        return start + 1;
    }

    public static boolean arrayContains(long[] array, long longToFind) {
        return ArrayUtil.arrayIndexOf(array, longToFind) != -1;
    }

    public static boolean arrayContains(long[] array, long[] arrayToFind) {
        return ArrayUtil.arrayIndexOf(array, arrayToFind) != -1;
    }

    public static int arrayIndexOf(int[] array, int intToFind) {
        return ArrayUtil.arrayIndexOf(array, intToFind, 0);
    }

    public static int arrayIndexOf(int[] array, int[] arrayToFind) {
        return ArrayUtil.arrayIndexOf(array, arrayToFind, 0);
    }

    public static int arrayIndexOf(int[] array, int intToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        for (int i = startIndex; i < array.length; ++i) {
            if (intToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int arrayIndexOf(int[] array, int[] arrayToFind, int startIndex) {
        if (array == null || arrayToFind == null) {
            return -1;
        }
        int sourceLength = array.length;
        int targetLength = arrayToFind.length;
        if (startIndex >= sourceLength) {
            return targetLength == 0 ? sourceLength : -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (targetLength == 0) {
            return startIndex;
        }
        int first = arrayToFind[0];
        int i = startIndex;
        int max = sourceLength - targetLength;
        block0: while (true) {
            if (i <= max && array[i] != first) {
                ++i;
                continue;
            }
            if (i > max) {
                return -1;
            }
            int j = i + 1;
            int end = j + targetLength - 1;
            int k = 1;
            while (j < end) {
                if (array[j++] == arrayToFind[k++]) continue;
                ++i;
                continue block0;
            }
            break;
        }
        return i;
    }

    public static int arrayLastIndexOf(int[] array, int intToFind) {
        return ArrayUtil.arrayLastIndexOf(array, intToFind, Integer.MAX_VALUE);
    }

    public static int arrayLastIndexOf(int[] array, int[] arrayToFind) {
        return ArrayUtil.arrayLastIndexOf(array, arrayToFind, Integer.MAX_VALUE);
    }

    public static int arrayLastIndexOf(int[] array, int intToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        for (int i = startIndex; i >= 0; --i) {
            if (intToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int arrayLastIndexOf(int[] array, int[] arrayToFind, int startIndex) {
        int start;
        if (array == null || arrayToFind == null) {
            return -1;
        }
        int sourceLength = array.length;
        int targetLength = arrayToFind.length;
        int rightIndex = sourceLength - targetLength;
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex > rightIndex) {
            startIndex = rightIndex;
        }
        if (targetLength == 0) {
            return startIndex;
        }
        int lastIndex = targetLength - 1;
        int last = arrayToFind[lastIndex];
        int min = targetLength - 1;
        int i = min + startIndex;
        block0: while (true) {
            if (i >= min && array[i] != last) {
                --i;
                continue;
            }
            if (i < min) {
                return -1;
            }
            int j = i - 1;
            start = j - (targetLength - 1);
            int k = lastIndex - 1;
            while (j > start) {
                if (array[j--] == arrayToFind[k--]) continue;
                --i;
                continue block0;
            }
            break;
        }
        return start + 1;
    }

    public static boolean arrayContains(int[] array, int intToFind) {
        return ArrayUtil.arrayIndexOf(array, intToFind) != -1;
    }

    public static boolean arrayContains(int[] array, int[] arrayToFind) {
        return ArrayUtil.arrayIndexOf(array, arrayToFind) != -1;
    }

    public static int arrayIndexOf(short[] array, short shortToFind) {
        return ArrayUtil.arrayIndexOf(array, shortToFind, 0);
    }

    public static int arrayIndexOf(short[] array, short[] arrayToFind) {
        return ArrayUtil.arrayIndexOf(array, arrayToFind, 0);
    }

    public static int arrayIndexOf(short[] array, short shortToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        for (int i = startIndex; i < array.length; ++i) {
            if (shortToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int arrayIndexOf(short[] array, short[] arrayToFind, int startIndex) {
        if (array == null || arrayToFind == null) {
            return -1;
        }
        int sourceLength = array.length;
        int targetLength = arrayToFind.length;
        if (startIndex >= sourceLength) {
            return targetLength == 0 ? sourceLength : -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (targetLength == 0) {
            return startIndex;
        }
        short first = arrayToFind[0];
        int i = startIndex;
        int max = sourceLength - targetLength;
        block0: while (true) {
            if (i <= max && array[i] != first) {
                ++i;
                continue;
            }
            if (i > max) {
                return -1;
            }
            int j = i + 1;
            int end = j + targetLength - 1;
            int k = 1;
            while (j < end) {
                if (array[j++] == arrayToFind[k++]) continue;
                ++i;
                continue block0;
            }
            break;
        }
        return i;
    }

    public static int arrayLastIndexOf(short[] array, short shortToFind) {
        return ArrayUtil.arrayLastIndexOf(array, shortToFind, Integer.MAX_VALUE);
    }

    public static int arrayLastIndexOf(short[] array, short[] arrayToFind) {
        return ArrayUtil.arrayLastIndexOf(array, arrayToFind, Integer.MAX_VALUE);
    }

    public static int arrayLastIndexOf(short[] array, short shortToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        for (int i = startIndex; i >= 0; --i) {
            if (shortToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int arrayLastIndexOf(short[] array, short[] arrayToFind, int startIndex) {
        int start;
        if (array == null || arrayToFind == null) {
            return -1;
        }
        int sourceLength = array.length;
        int targetLength = arrayToFind.length;
        int rightIndex = sourceLength - targetLength;
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex > rightIndex) {
            startIndex = rightIndex;
        }
        if (targetLength == 0) {
            return startIndex;
        }
        int lastIndex = targetLength - 1;
        short last = arrayToFind[lastIndex];
        int min = targetLength - 1;
        int i = min + startIndex;
        block0: while (true) {
            if (i >= min && array[i] != last) {
                --i;
                continue;
            }
            if (i < min) {
                return -1;
            }
            int j = i - 1;
            start = j - (targetLength - 1);
            int k = lastIndex - 1;
            while (j > start) {
                if (array[j--] == arrayToFind[k--]) continue;
                --i;
                continue block0;
            }
            break;
        }
        return start + 1;
    }

    public static boolean arrayContains(short[] array, short shortToFind) {
        return ArrayUtil.arrayIndexOf(array, shortToFind) != -1;
    }

    public static boolean arrayContains(short[] array, short[] arrayToFind) {
        return ArrayUtil.arrayIndexOf(array, arrayToFind) != -1;
    }

    public static int arrayIndexOf(byte[] array, byte byteToFind) {
        return ArrayUtil.arrayIndexOf(array, byteToFind, 0);
    }

    public static int arrayIndexOf(byte[] array, byte[] arrayToFind) {
        return ArrayUtil.arrayIndexOf(array, arrayToFind, 0);
    }

    public static int arrayIndexOf(byte[] array, byte byteToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        for (int i = startIndex; i < array.length; ++i) {
            if (byteToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int arrayIndexOf(byte[] array, byte[] arrayToFind, int startIndex) {
        if (array == null || arrayToFind == null) {
            return -1;
        }
        int sourceLength = array.length;
        int targetLength = arrayToFind.length;
        if (startIndex >= sourceLength) {
            return targetLength == 0 ? sourceLength : -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (targetLength == 0) {
            return startIndex;
        }
        byte first = arrayToFind[0];
        int i = startIndex;
        int max = sourceLength - targetLength;
        block0: while (true) {
            if (i <= max && array[i] != first) {
                ++i;
                continue;
            }
            if (i > max) {
                return -1;
            }
            int j = i + 1;
            int end = j + targetLength - 1;
            int k = 1;
            while (j < end) {
                if (array[j++] == arrayToFind[k++]) continue;
                ++i;
                continue block0;
            }
            break;
        }
        return i;
    }

    public static int arrayLastIndexOf(byte[] array, byte byteToFind) {
        return ArrayUtil.arrayLastIndexOf(array, byteToFind, Integer.MAX_VALUE);
    }

    public static int arrayLastIndexOf(byte[] array, byte[] arrayToFind) {
        return ArrayUtil.arrayLastIndexOf(array, arrayToFind, Integer.MAX_VALUE);
    }

    public static int arrayLastIndexOf(byte[] array, byte byteToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        for (int i = startIndex; i >= 0; --i) {
            if (byteToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int arrayLastIndexOf(byte[] array, byte[] arrayToFind, int startIndex) {
        int start;
        if (array == null || arrayToFind == null) {
            return -1;
        }
        int sourceLength = array.length;
        int targetLength = arrayToFind.length;
        int rightIndex = sourceLength - targetLength;
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex > rightIndex) {
            startIndex = rightIndex;
        }
        if (targetLength == 0) {
            return startIndex;
        }
        int lastIndex = targetLength - 1;
        byte last = arrayToFind[lastIndex];
        int min = targetLength - 1;
        int i = min + startIndex;
        block0: while (true) {
            if (i >= min && array[i] != last) {
                --i;
                continue;
            }
            if (i < min) {
                return -1;
            }
            int j = i - 1;
            start = j - (targetLength - 1);
            int k = lastIndex - 1;
            while (j > start) {
                if (array[j--] == arrayToFind[k--]) continue;
                --i;
                continue block0;
            }
            break;
        }
        return start + 1;
    }

    public static boolean arrayContains(byte[] array, byte byteToFind) {
        return ArrayUtil.arrayIndexOf(array, byteToFind) != -1;
    }

    public static boolean arrayContains(byte[] array, byte[] arrayToFind) {
        return ArrayUtil.arrayIndexOf(array, arrayToFind) != -1;
    }

    public static int arrayIndexOf(double[] array, double doubleToFind) {
        return ArrayUtil.arrayIndexOf(array, doubleToFind, 0, 0.0);
    }

    public static int arrayIndexOf(double[] array, double doubleToFind, double tolerance) {
        return ArrayUtil.arrayIndexOf(array, doubleToFind, 0, tolerance);
    }

    public static int arrayIndexOf(double[] array, double[] arrayToFind) {
        return ArrayUtil.arrayIndexOf(array, arrayToFind, 0, 0.0);
    }

    public static int arrayIndexOf(double[] array, double[] arrayToFind, double tolerance) {
        return ArrayUtil.arrayIndexOf(array, arrayToFind, 0, tolerance);
    }

    public static int arrayIndexOf(double[] array, double doubleToFind, int startIndex) {
        return ArrayUtil.arrayIndexOf(array, doubleToFind, startIndex, 0.0);
    }

    public static int arrayIndexOf(double[] array, double doubleToFind, int startIndex, double tolerance) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        double min = doubleToFind - tolerance;
        double max = doubleToFind + tolerance;
        for (int i = startIndex; i < array.length; ++i) {
            if (!(array[i] >= min) || !(array[i] <= max)) continue;
            return i;
        }
        return -1;
    }

    public static int arrayIndexOf(double[] array, double[] arrayToFind, int startIndex) {
        return ArrayUtil.arrayIndexOf(array, arrayToFind, startIndex, 0.0);
    }

    public static int arrayIndexOf(double[] array, double[] arrayToFind, int startIndex, double tolerance) {
        if (array == null || arrayToFind == null) {
            return -1;
        }
        int sourceLength = array.length;
        int targetLength = arrayToFind.length;
        if (startIndex >= sourceLength) {
            return targetLength == 0 ? sourceLength : -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (targetLength == 0) {
            return startIndex;
        }
        double firstMin = arrayToFind[0] - tolerance;
        double firstMax = arrayToFind[0] + tolerance;
        int i = startIndex;
        int max = sourceLength - targetLength;
        block0: while (true) {
            if (i <= max && (array[i] < firstMin || array[i] > firstMax)) {
                ++i;
                continue;
            }
            if (i > max) {
                return -1;
            }
            int j = i + 1;
            int end = j + targetLength - 1;
            int k = 1;
            while (j < end) {
                int n = j++;
                int n2 = k++;
                if (!(Math.abs(array[n] - arrayToFind[n2]) > tolerance)) continue;
                ++i;
                continue block0;
            }
            break;
        }
        return i;
    }

    public static int arrayLastIndexOf(double[] array, double doubleToFind) {
        return ArrayUtil.arrayLastIndexOf(array, doubleToFind, Integer.MAX_VALUE, 0.0);
    }

    public static int arrayLastIndexOf(double[] array, double doubleToFind, double tolerance) {
        return ArrayUtil.arrayLastIndexOf(array, doubleToFind, Integer.MAX_VALUE, tolerance);
    }

    public static int arrayLastIndexOf(double[] array, double[] arrayToFind) {
        return ArrayUtil.arrayLastIndexOf(array, arrayToFind, Integer.MAX_VALUE, 0.0);
    }

    public static int arrayLastIndexOf(double[] array, double[] arrayToFind, double tolerance) {
        return ArrayUtil.arrayLastIndexOf(array, arrayToFind, Integer.MAX_VALUE, tolerance);
    }

    public static int arrayLastIndexOf(double[] array, double doubleToFind, int startIndex) {
        return ArrayUtil.arrayLastIndexOf(array, doubleToFind, startIndex, 0.0);
    }

    public static int arrayLastIndexOf(double[] array, double doubleToFind, int startIndex, double tolerance) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        double min = doubleToFind - tolerance;
        double max = doubleToFind + tolerance;
        for (int i = startIndex; i >= 0; --i) {
            if (!(array[i] >= min) || !(array[i] <= max)) continue;
            return i;
        }
        return -1;
    }

    public static int arrayLastIndexOf(double[] array, double[] arrayToFind, int startIndex) {
        return ArrayUtil.arrayLastIndexOf(array, arrayToFind, startIndex, 0.0);
    }

    public static int arrayLastIndexOf(double[] array, double[] arrayToFind, int startIndex, double tolerance) {
        int start;
        if (array == null || arrayToFind == null) {
            return -1;
        }
        int sourceLength = array.length;
        int targetLength = arrayToFind.length;
        int rightIndex = sourceLength - targetLength;
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex > rightIndex) {
            startIndex = rightIndex;
        }
        if (targetLength == 0) {
            return startIndex;
        }
        int lastIndex = targetLength - 1;
        double lastMin = arrayToFind[lastIndex] - tolerance;
        double lastMax = arrayToFind[lastIndex] + tolerance;
        int min = targetLength - 1;
        int i = min + startIndex;
        block0: while (true) {
            if (i >= min && (array[i] < lastMin || array[i] > lastMax)) {
                --i;
                continue;
            }
            if (i < min) {
                return -1;
            }
            int j = i - 1;
            start = j - (targetLength - 1);
            int k = lastIndex - 1;
            while (j > start) {
                int n = j--;
                int n2 = k--;
                if (!(Math.abs(array[n] - arrayToFind[n2]) > tolerance)) continue;
                --i;
                continue block0;
            }
            break;
        }
        return start + 1;
    }

    public static boolean arrayContains(double[] array, double doubleToFind) {
        return ArrayUtil.arrayIndexOf(array, doubleToFind) != -1;
    }

    public static boolean arrayContains(double[] array, double doubleToFind, double tolerance) {
        return ArrayUtil.arrayIndexOf(array, doubleToFind, tolerance) != -1;
    }

    public static boolean arrayContains(double[] array, double[] arrayToFind) {
        return ArrayUtil.arrayIndexOf(array, arrayToFind) != -1;
    }

    public static boolean arrayContains(double[] array, double[] arrayToFind, double tolerance) {
        return ArrayUtil.arrayIndexOf(array, arrayToFind, tolerance) != -1;
    }

    public static int arrayIndexOf(float[] array, float floatToFind) {
        return ArrayUtil.arrayIndexOf(array, floatToFind, 0, 0.0f);
    }

    public static int arrayIndexOf(float[] array, float floatToFind, float tolerance) {
        return ArrayUtil.arrayIndexOf(array, floatToFind, 0, tolerance);
    }

    public static int arrayIndexOf(float[] array, float[] arrayToFind) {
        return ArrayUtil.arrayIndexOf(array, arrayToFind, 0, 0.0f);
    }

    public static int arrayIndexOf(float[] array, float[] arrayToFind, float tolerance) {
        return ArrayUtil.arrayIndexOf(array, arrayToFind, 0, tolerance);
    }

    public static int arrayIndexOf(float[] array, float floatToFind, int startIndex) {
        return ArrayUtil.arrayIndexOf(array, floatToFind, startIndex, 0.0f);
    }

    public static int arrayIndexOf(float[] array, float floatToFind, int startIndex, float tolerance) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        float min = floatToFind - tolerance;
        float max = floatToFind + tolerance;
        for (int i = startIndex; i < array.length; ++i) {
            if (!(array[i] >= min) || !(array[i] <= max)) continue;
            return i;
        }
        return -1;
    }

    public static int arrayIndexOf(float[] array, float[] arrayToFind, int startIndex) {
        return ArrayUtil.arrayIndexOf(array, arrayToFind, startIndex, 0.0f);
    }

    public static int arrayIndexOf(float[] array, float[] arrayToFind, int startIndex, float tolerance) {
        if (array == null || arrayToFind == null) {
            return -1;
        }
        int sourceLength = array.length;
        int targetLength = arrayToFind.length;
        if (startIndex >= sourceLength) {
            return targetLength == 0 ? sourceLength : -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (targetLength == 0) {
            return startIndex;
        }
        float firstMin = arrayToFind[0] - tolerance;
        float firstMax = arrayToFind[0] + tolerance;
        int i = startIndex;
        int max = sourceLength - targetLength;
        block0: while (true) {
            if (i <= max && (array[i] < firstMin || array[i] > firstMax)) {
                ++i;
                continue;
            }
            if (i > max) {
                return -1;
            }
            int j = i + 1;
            int end = j + targetLength - 1;
            int k = 1;
            while (j < end) {
                int n = j++;
                int n2 = k++;
                if (!(Math.abs(array[n] - arrayToFind[n2]) > tolerance)) continue;
                ++i;
                continue block0;
            }
            break;
        }
        return i;
    }

    public static int arrayLastIndexOf(float[] array, float floatToFind) {
        return ArrayUtil.arrayLastIndexOf(array, floatToFind, Integer.MAX_VALUE, 0.0f);
    }

    public static int arrayLastIndexOf(float[] array, float floatToFind, float tolerance) {
        return ArrayUtil.arrayLastIndexOf(array, floatToFind, Integer.MAX_VALUE, tolerance);
    }

    public static int arrayLastIndexOf(float[] array, float[] arrayToFind) {
        return ArrayUtil.arrayLastIndexOf(array, arrayToFind, Integer.MAX_VALUE, 0.0f);
    }

    public static int arrayLastIndexOf(float[] array, float[] arrayToFind, float tolerance) {
        return ArrayUtil.arrayLastIndexOf(array, arrayToFind, Integer.MAX_VALUE, tolerance);
    }

    public static int arrayLastIndexOf(float[] array, float floatToFind, int startIndex) {
        return ArrayUtil.arrayLastIndexOf(array, floatToFind, startIndex, 0.0f);
    }

    public static int arrayLastIndexOf(float[] array, float floatToFind, int startIndex, float tolerance) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        float min = floatToFind - tolerance;
        float max = floatToFind + tolerance;
        for (int i = startIndex; i >= 0; --i) {
            if (!(array[i] >= min) || !(array[i] <= max)) continue;
            return i;
        }
        return -1;
    }

    public static int arrayLastIndexOf(float[] array, float[] arrayToFind, int startIndex) {
        return ArrayUtil.arrayLastIndexOf(array, arrayToFind, startIndex, 0.0f);
    }

    public static int arrayLastIndexOf(float[] array, float[] arrayToFind, int startIndex, float tolerance) {
        int start;
        if (array == null || arrayToFind == null) {
            return -1;
        }
        int sourceLength = array.length;
        int targetLength = arrayToFind.length;
        int rightIndex = sourceLength - targetLength;
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex > rightIndex) {
            startIndex = rightIndex;
        }
        if (targetLength == 0) {
            return startIndex;
        }
        int lastIndex = targetLength - 1;
        float lastMin = arrayToFind[lastIndex] - tolerance;
        float lastMax = arrayToFind[lastIndex] + tolerance;
        int min = targetLength - 1;
        int i = min + startIndex;
        block0: while (true) {
            if (i >= min && (array[i] < lastMin || array[i] > lastMax)) {
                --i;
                continue;
            }
            if (i < min) {
                return -1;
            }
            int j = i - 1;
            start = j - (targetLength - 1);
            int k = lastIndex - 1;
            while (j > start) {
                int n = j--;
                int n2 = k--;
                if (!(Math.abs(array[n] - arrayToFind[n2]) > tolerance)) continue;
                --i;
                continue block0;
            }
            break;
        }
        return start + 1;
    }

    public static boolean arrayContains(float[] array, float floatToFind) {
        return ArrayUtil.arrayIndexOf(array, floatToFind) != -1;
    }

    public static boolean arrayContains(float[] array, float floatToFind, float tolerance) {
        return ArrayUtil.arrayIndexOf(array, floatToFind, tolerance) != -1;
    }

    public static boolean arrayContains(float[] array, float[] arrayToFind) {
        return ArrayUtil.arrayIndexOf(array, arrayToFind) != -1;
    }

    public static boolean arrayContains(float[] array, float[] arrayToFind, float tolerance) {
        return ArrayUtil.arrayIndexOf(array, arrayToFind, tolerance) != -1;
    }

    public static int arrayIndexOf(boolean[] array, boolean booleanToFind) {
        return ArrayUtil.arrayIndexOf(array, booleanToFind, 0);
    }

    public static int arrayIndexOf(boolean[] array, boolean[] arrayToFind) {
        return ArrayUtil.arrayIndexOf(array, arrayToFind, 0);
    }

    public static int arrayIndexOf(boolean[] array, boolean booleanToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        for (int i = startIndex; i < array.length; ++i) {
            if (booleanToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int arrayIndexOf(boolean[] array, boolean[] arrayToFind, int startIndex) {
        if (array == null || arrayToFind == null) {
            return -1;
        }
        int sourceLength = array.length;
        int targetLength = arrayToFind.length;
        if (startIndex >= sourceLength) {
            return targetLength == 0 ? sourceLength : -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (targetLength == 0) {
            return startIndex;
        }
        boolean first = arrayToFind[0];
        int i = startIndex;
        int max = sourceLength - targetLength;
        block0: while (true) {
            if (i <= max && array[i] != first) {
                ++i;
                continue;
            }
            if (i > max) {
                return -1;
            }
            int j = i + 1;
            int end = j + targetLength - 1;
            int k = 1;
            while (j < end) {
                if (array[j++] == arrayToFind[k++]) continue;
                ++i;
                continue block0;
            }
            break;
        }
        return i;
    }

    public static int arrayLastIndexOf(boolean[] array, boolean booleanToFind) {
        return ArrayUtil.arrayLastIndexOf(array, booleanToFind, Integer.MAX_VALUE);
    }

    public static int arrayLastIndexOf(boolean[] array, boolean[] arrayToFind) {
        return ArrayUtil.arrayLastIndexOf(array, arrayToFind, Integer.MAX_VALUE);
    }

    public static int arrayLastIndexOf(boolean[] array, boolean booleanToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        for (int i = startIndex; i >= 0; --i) {
            if (booleanToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int arrayLastIndexOf(boolean[] array, boolean[] arrayToFind, int startIndex) {
        int start;
        if (array == null || arrayToFind == null) {
            return -1;
        }
        int sourceLength = array.length;
        int targetLength = arrayToFind.length;
        int rightIndex = sourceLength - targetLength;
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex > rightIndex) {
            startIndex = rightIndex;
        }
        if (targetLength == 0) {
            return startIndex;
        }
        int lastIndex = targetLength - 1;
        boolean last = arrayToFind[lastIndex];
        int min = targetLength - 1;
        int i = min + startIndex;
        block0: while (true) {
            if (i >= min && array[i] != last) {
                --i;
                continue;
            }
            if (i < min) {
                return -1;
            }
            int j = i - 1;
            start = j - (targetLength - 1);
            int k = lastIndex - 1;
            while (j > start) {
                if (array[j--] == arrayToFind[k--]) continue;
                --i;
                continue block0;
            }
            break;
        }
        return start + 1;
    }

    public static boolean arrayContains(boolean[] array, boolean booleanToFind) {
        return ArrayUtil.arrayIndexOf(array, booleanToFind) != -1;
    }

    public static boolean arrayContains(boolean[] array, boolean[] arrayToFind) {
        return ArrayUtil.arrayIndexOf(array, arrayToFind) != -1;
    }

    public static int arrayIndexOf(char[] array, char charToFind) {
        return ArrayUtil.arrayIndexOf(array, charToFind, 0);
    }

    public static int arrayIndexOf(char[] array, char[] arrayToFind) {
        return ArrayUtil.arrayIndexOf(array, arrayToFind, 0);
    }

    public static int arrayIndexOf(char[] array, char charToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        for (int i = startIndex; i < array.length; ++i) {
            if (charToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int arrayIndexOf(char[] array, char[] arrayToFind, int startIndex) {
        if (array == null || arrayToFind == null) {
            return -1;
        }
        int sourceLength = array.length;
        int targetLength = arrayToFind.length;
        if (startIndex >= sourceLength) {
            return targetLength == 0 ? sourceLength : -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (targetLength == 0) {
            return startIndex;
        }
        char first = arrayToFind[0];
        int i = startIndex;
        int max = sourceLength - targetLength;
        block0: while (true) {
            if (i <= max && array[i] != first) {
                ++i;
                continue;
            }
            if (i > max) {
                return -1;
            }
            int j = i + 1;
            int end = j + targetLength - 1;
            int k = 1;
            while (j < end) {
                if (array[j++] == arrayToFind[k++]) continue;
                ++i;
                continue block0;
            }
            break;
        }
        return i;
    }

    public static int arrayLastIndexOf(char[] array, char charToFind) {
        return ArrayUtil.arrayLastIndexOf(array, charToFind, Integer.MAX_VALUE);
    }

    public static int arrayLastIndexOf(char[] array, char[] arrayToFind) {
        return ArrayUtil.arrayLastIndexOf(array, arrayToFind, Integer.MAX_VALUE);
    }

    public static int arrayLastIndexOf(char[] array, char charToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        for (int i = startIndex; i >= 0; --i) {
            if (charToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int arrayLastIndexOf(char[] array, char[] arrayToFind, int startIndex) {
        int start;
        if (array == null || arrayToFind == null) {
            return -1;
        }
        int sourceLength = array.length;
        int targetLength = arrayToFind.length;
        int rightIndex = sourceLength - targetLength;
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex > rightIndex) {
            startIndex = rightIndex;
        }
        if (targetLength == 0) {
            return startIndex;
        }
        int lastIndex = targetLength - 1;
        char last = arrayToFind[lastIndex];
        int min = targetLength - 1;
        int i = min + startIndex;
        block0: while (true) {
            if (i >= min && array[i] != last) {
                --i;
                continue;
            }
            if (i < min) {
                return -1;
            }
            int j = i - 1;
            start = j - (targetLength - 1);
            int k = lastIndex - 1;
            while (j > start) {
                if (array[j--] == arrayToFind[k--]) continue;
                --i;
                continue block0;
            }
            break;
        }
        return start + 1;
    }

    public static boolean arrayContains(char[] array, char charToFind) {
        return ArrayUtil.arrayIndexOf(array, charToFind) != -1;
    }

    public static boolean arrayContains(char[] array, char[] arrayToFind) {
        return ArrayUtil.arrayIndexOf(array, arrayToFind) != -1;
    }

    public static Object[] toArray(Object value) {
        Object[] values;
        if (value == null) {
            return EMPTY_ARRAY;
        }
        if (value.getClass().isArray()) {
            values = (Object[])value;
        } else if (List.class.isInstance(value)) {
            List list = (List)value;
            values = list.toArray();
        } else {
            values = new Object[]{value};
        }
        return values;
    }
}

