/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.commons.tools;

import java.text.DecimalFormat;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tinygroup.commons.tools.Assert;
import org.tinygroup.commons.tools.CollectionUtil;
import org.tinygroup.commons.tools.StringUtil;

public class HumanReadableSize {
    private static final Long ONE = 1L;
    private static final Long ONE_KILO = 1024L;
    private static final Long ONE_MEGA = 0x100000L;
    private static final Long ONE_GIGA = 0x40000000L;
    private static final Long ONE_TERA = 0x10000000000L;
    private static final Map<String, Long> UNIT_NAMES = CollectionUtil.createHashMap();
    private static final Pattern REGEXP = Pattern.compile("(\\d+(\\.\\d+)?)\\s*(K|M|G|T)?", 2);
    private final long value;
    private final String humanReadable;

    public HumanReadableSize(String humanReadable) {
        this.value = HumanReadableSize.parse(humanReadable, "-1", "n/a");
        this.humanReadable = HumanReadableSize.toHumanReadble(this.value);
    }

    public HumanReadableSize(long value) {
        this.value = value < 0L ? -1L : value;
        this.humanReadable = HumanReadableSize.toHumanReadble(this.value);
    }

    public static long parse(String humanReadableSize) {
        return HumanReadableSize.parse(humanReadableSize, null);
    }

    private static long parse(String humanReadableSize, String ... nas) {
        humanReadableSize = Assert.assertNotNull(StringUtil.trimToNull(humanReadableSize), "human readble size", new Object[0]);
        if (nas != null) {
            for (String na : nas) {
                if (na == null || !na.equalsIgnoreCase(humanReadableSize)) continue;
                return -1L;
            }
        }
        Matcher matcher = REGEXP.matcher(humanReadableSize);
        Assert.assertTrue(matcher.matches(), "wrong format: %s", humanReadableSize);
        double size = Double.parseDouble(matcher.group(1));
        String unit = StringUtil.trimToNull(matcher.group(3));
        if (unit != null) {
            size *= (double)UNIT_NAMES.get(unit.toUpperCase()).longValue();
        }
        return (long)size;
    }

    public static String toHumanReadble(long size) {
        if (size < 0L) {
            return "n/a";
        }
        DecimalFormat format = new DecimalFormat("#.##");
        if (size / ONE_TERA > 0L) {
            return format.format((double)size / (double)ONE_TERA.longValue()) + "T";
        }
        if (size / ONE_GIGA > 0L) {
            return format.format((double)size / (double)ONE_GIGA.longValue()) + "G";
        }
        if (size / ONE_MEGA > 0L) {
            return format.format((double)size / (double)ONE_MEGA.longValue()) + "M";
        }
        if (size / ONE_KILO > 0L) {
            return format.format((double)size / (double)ONE_KILO.longValue()) + "K";
        }
        return String.valueOf(size);
    }

    public long getValue() {
        return this.value;
    }

    public String getHumanReadable() {
        return this.humanReadable;
    }

    public int hashCode() {
        return 31 + (int)(this.value ^ this.value >>> 32);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof HumanReadableSize) {
            return this.value == ((HumanReadableSize)obj).value;
        }
        return false;
    }

    public String toString() {
        return this.humanReadable;
    }

    static {
        UNIT_NAMES.put("B", ONE);
        UNIT_NAMES.put("K", ONE_KILO);
        UNIT_NAMES.put("M", ONE_MEGA);
        UNIT_NAMES.put("G", ONE_GIGA);
        UNIT_NAMES.put("T", ONE_TERA);
    }
}

