/*
 * Decompiled with CFR 0.152.
 */
package com.ql.util.express;

import com.ql.util.express.ExpressLoader;
import com.ql.util.express.ExpressRunner;
import com.ql.util.express.IExpressContext;
import com.ql.util.express.instruction.OperateDataCacheManager;
import java.util.HashMap;
import java.util.Map;

public class InstructionSetContext
implements IExpressContext<String, Object> {
    private boolean isExpandToParent = true;
    private IExpressContext<String, Object> parent = null;
    private Map<String, Object> content;
    private Map<String, Object> symbolTable = new HashMap<String, Object>();
    private ExpressLoader expressLoader;
    private boolean isSupportDynamicFieldName = false;
    private ExpressRunner runner;

    public ExpressRunner getRunner() {
        return this.runner;
    }

    public InstructionSetContext(boolean aIsExpandToParent, ExpressRunner aRunner, IExpressContext<String, Object> aParent, ExpressLoader aExpressLoader, boolean aIsSupportDynamicFieldName) {
        this.initial(aIsExpandToParent, aRunner, aParent, aExpressLoader, aIsSupportDynamicFieldName);
    }

    public void initial(boolean aIsExpandToParent, ExpressRunner aRunner, IExpressContext<String, Object> aParent, ExpressLoader aExpressLoader, boolean aIsSupportDynamicFieldName) {
        this.isExpandToParent = aIsExpandToParent;
        this.runner = aRunner;
        this.parent = aParent;
        this.expressLoader = aExpressLoader;
        this.isSupportDynamicFieldName = aIsSupportDynamicFieldName;
    }

    public void clear() {
        this.isExpandToParent = true;
        this.parent = null;
        this.content = null;
        this.expressLoader = null;
        this.isSupportDynamicFieldName = false;
        this.runner = null;
        this.symbolTable.clear();
    }

    public void exportSymbol(String varName, Object aliasNameObject) throws Exception {
        if (this.parent != null && this.parent instanceof InstructionSetContext) {
            ((InstructionSetContext)this.parent).exportSymbol(varName, aliasNameObject);
        } else {
            this.addSymbol(varName, aliasNameObject);
        }
    }

    public void addSymbol(String varName, Object aliasNameObject) throws Exception {
        if (this.symbolTable.containsKey(varName)) {
            throw new Exception("\u53d8\u91cf" + varName + "\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u5b9a\u4e49\uff0c\u4e5f\u4e0d\u80fd\u518d\u4ece\u51fd\u6570\u5185\u90e8 exprot ");
        }
        this.symbolTable.put(varName, aliasNameObject);
    }

    public void addSymbol(Map<String, Object> aliasNameObjects) throws Exception {
        this.symbolTable.putAll(aliasNameObjects);
    }

    public void setSupportDynamicFieldName(boolean isSupportDynamicFieldName) {
        this.isSupportDynamicFieldName = isSupportDynamicFieldName;
    }

    public boolean isSupportDynamicFieldName() {
        return this.isSupportDynamicFieldName;
    }

    public ExpressRunner getExpressRunner() {
        return this.runner;
    }

    public Object findAliasOrDefSymbol(String varName) throws Exception {
        Object result = this.symbolTable.get(varName);
        if (result == null) {
            result = this.parent != null && this.parent instanceof InstructionSetContext ? ((InstructionSetContext)this.parent).findAliasOrDefSymbol(varName) : null;
        }
        return result;
    }

    public Object getSymbol(String varName) throws Exception {
        Object result = this.symbolTable.get(varName);
        if (result == null && this.expressLoader != null) {
            result = this.expressLoader.getInstructionSet(varName);
        }
        if (result == null) {
            if (this.isExpandToParent && this.parent != null && this.parent instanceof InstructionSetContext) {
                result = ((InstructionSetContext)this.parent).getSymbol(varName);
            } else {
                result = OperateDataCacheManager.fetchOperateDataAttr(varName, null);
                this.addSymbol(varName, result);
            }
        }
        return result;
    }

    public ExpressLoader getExpressLoader() {
        return this.expressLoader;
    }

    public IExpressContext<String, Object> getParent() {
        return this.parent;
    }

    @Override
    public Object get(Object key) {
        if (this.content != null && this.content.containsKey(key)) {
            return this.content.get(key);
        }
        if (this.isExpandToParent && this.parent != null) {
            return this.parent.get(key);
        }
        return null;
    }

    @Override
    public Object put(String key, Object value) {
        if (this.content != null && this.content.containsKey(key)) {
            return this.content.put(key, value);
        }
        if (!this.isExpandToParent) {
            if (this.content == null) {
                this.content = new HashMap<String, Object>();
            }
            return this.content.put(key, value);
        }
        if (this.parent != null) {
            return this.parent.put(key, value);
        }
        throw new RuntimeException("\u6ca1\u6709\u5b9a\u4e49\u5c40\u90e8\u53d8\u91cf\uff1a" + key + ",\u800c\u4e14\u6ca1\u6709\u5168\u5c40\u4e0a\u4e0b\u6587");
    }
}

