/*
 * Decompiled with CFR 0.152.
 */
package com.ql.util.express.parse;

import com.ql.util.express.parse.Word;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;

public class WordSplit {
    public static Word[] parse(String[] splitWord, String str) throws Exception {
        if (str == null) {
            return new Word[0];
        }
        int line = 1;
        ArrayList<Word> list = new ArrayList<Word>();
        int i = 0;
        int point = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c == '\"' || c == '\'') {
                int index = str.indexOf(c, i + 1);
                while (index > 0 && str.charAt(index - 1) == '\\') {
                    index = str.indexOf(c, index + 1);
                }
                if (index < 0) {
                    throw new Exception("\u5b57\u7b26\u4e32\u6ca1\u6709\u5173\u95ed");
                }
                String tempDealStr = str.substring(i, index + 1);
                String tmpResult = "";
                int tmpPoint = tempDealStr.indexOf("\\");
                while (tmpPoint >= 0) {
                    tmpResult = tmpResult + tempDealStr.substring(0, tmpPoint);
                    if (tmpPoint == tempDealStr.length() - 1) {
                        throw new Exception("\u5b57\u7b26\u4e32\u4e2d\u7684\\\u9519\u8bef:" + tempDealStr);
                    }
                    tmpResult = tmpResult + tempDealStr.substring(tmpPoint + 1, tmpPoint + 2);
                    tempDealStr = tempDealStr.substring(tmpPoint + 2);
                    tmpPoint = tempDealStr.indexOf("\\");
                }
                tmpResult = tmpResult + tempDealStr;
                list.add(new Word(tmpResult, line, i));
                if (point < i) {
                    list.add(new Word(str.substring(point, i), line, i));
                }
                point = i = index + 1;
                continue;
            }
            if (c == '.' && point < i && WordSplit.isNumber(str.substring(point, i))) {
                ++i;
                continue;
            }
            if (c == ' ' || c == '\r' || c == '\n' || c == '\t' || c == '\f') {
                if (point < i) {
                    list.add(new Word(str.substring(point, i), line, i));
                }
                if (c == '\n') {
                    ++line;
                }
                point = ++i;
                continue;
            }
            boolean isFind = false;
            for (String s : splitWord) {
                int length = s.length();
                if (i + length > str.length() || !str.substring(i, i + length).equals(s)) continue;
                if (point < i) {
                    list.add(new Word(str.substring(point, i), line, i));
                }
                list.add(new Word(str.substring(i, i + length), line, i));
                point = i += length;
                isFind = true;
                break;
            }
            if (isFind) continue;
            ++i;
        }
        if (point < i) {
            list.add(new Word(str.substring(point, i), line, i));
        }
        Word[] result = new Word[list.size()];
        list.toArray(result);
        return result;
    }

    public static String[] sortSplitWord(String[] splitWord) {
        Arrays.sort(splitWord, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (o1.length() == o2.length()) {
                    return 0;
                }
                if (o1.length() > o2.length()) {
                    return -1;
                }
                return 1;
            }
        });
        return splitWord;
    }

    protected static boolean isNumber(String str) {
        if (str == null || str.equals("")) {
            return false;
        }
        char c = str.charAt(0);
        return c >= '0' && c <= '9';
    }

    public static String getPrintInfo(Object[] list, String splitOp) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < list.length; ++i) {
            if (i > 0) {
                buffer.append(splitOp);
            }
            buffer.append("{" + list[i] + "}");
        }
        return buffer.toString();
    }
}

