/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.cli;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.client.cli.CliArgsException;
import org.apache.flink.client.cli.CliFrontendParser;
import org.apache.flink.client.cli.CommandLineOptions;
import org.apache.flink.runtime.jobgraph.SavepointRestoreSettings;

public abstract class ProgramOptions
extends CommandLineOptions {
    private final String jarFilePath;
    private final String entryPointClass;
    private final List<URL> classpaths;
    private final String[] programArgs;
    private final int parallelism;
    private final boolean stdoutLogging;
    private final boolean detachedMode;
    private final boolean driverMode;
    private final boolean disableSubmitOptimization;
    private final SavepointRestoreSettings savepointSettings;
    private final List<URI> libjars;
    private final List<URI> files;
    private boolean isPython;

    protected ProgramOptions(CommandLine line) throws CliArgsException {
        boolean allowNonRestoredState;
        block22: {
            String[] args;
            super(line);
            this.isPython = false;
            String[] stringArray = args = line.hasOption(CliFrontendParser.ARGS_OPTION.getOpt()) ? line.getOptionValues(CliFrontendParser.ARGS_OPTION.getOpt()) : line.getArgs();
            if (line.hasOption(CliFrontendParser.PYFILES_OPTION.getLongOpt())) {
                String[] newArgs;
                this.isPython = true;
                if (line.hasOption(CliFrontendParser.PYMOD_OPTION.getLongOpt())) {
                    newArgs = new String[args.length + 4];
                    System.arraycopy(args, 0, newArgs, 2, args.length);
                    newArgs[0] = CliFrontendParser.PYFILES_OPTION.getLongOpt();
                    newArgs[1] = CliFrontendParser.PYFILES_OPTION.getValue();
                    newArgs[2] = CliFrontendParser.PYMOD_OPTION.getLongOpt();
                    newArgs[3] = CliFrontendParser.PYMOD_OPTION.getValue();
                } else {
                    newArgs = new String[args.length + 2];
                    System.arraycopy(args, 0, newArgs, 2, args.length);
                    newArgs[0] = CliFrontendParser.PYFILES_OPTION.getLongOpt();
                    newArgs[1] = CliFrontendParser.PYFILES_OPTION.getValue();
                }
                args = newArgs;
            }
            if (line.hasOption(CliFrontendParser.JAR_OPTION.getOpt())) {
                this.jarFilePath = line.getOptionValue(CliFrontendParser.JAR_OPTION.getOpt());
            } else if (args.length > 0) {
                if (args[0].endsWith(".py")) {
                    this.isPython = true;
                    this.jarFilePath = args[0];
                } else {
                    this.jarFilePath = args[0];
                    args = Arrays.copyOfRange(args, 1, args.length);
                }
            } else {
                this.jarFilePath = null;
            }
            this.programArgs = args;
            ArrayList<URL> classpaths = new ArrayList<URL>();
            if (line.hasOption(CliFrontendParser.CLASSPATH_OPTION.getOpt())) {
                for (String path : line.getOptionValues(CliFrontendParser.CLASSPATH_OPTION.getOpt())) {
                    try {
                        classpaths.add(new URL(path));
                    }
                    catch (MalformedURLException e) {
                        throw new CliArgsException("Bad syntax for classpath: " + path);
                    }
                }
            }
            this.classpaths = classpaths;
            String string = this.entryPointClass = line.hasOption(CliFrontendParser.CLASS_OPTION.getOpt()) ? line.getOptionValue(CliFrontendParser.CLASS_OPTION.getOpt()) : null;
            if (line.hasOption(CliFrontendParser.PARALLELISM_OPTION.getOpt())) {
                String parString = line.getOptionValue(CliFrontendParser.PARALLELISM_OPTION.getOpt());
                try {
                    this.parallelism = Integer.parseInt(parString);
                    if (this.parallelism <= 0) {
                        throw new NumberFormatException();
                    }
                    break block22;
                }
                catch (NumberFormatException e) {
                    throw new CliArgsException("The parallelism must be a positive number: " + parString);
                }
            }
            this.parallelism = -1;
        }
        this.stdoutLogging = !line.hasOption(CliFrontendParser.LOGGING_OPTION.getOpt());
        this.driverMode = line.hasOption(CliFrontendParser.DRIVER_OPTION.getOpt());
        this.detachedMode = line.hasOption(CliFrontendParser.DETACHED_OPTION.getOpt()) || line.hasOption(CliFrontendParser.YARN_DETACHED_OPTION.getOpt()) || this.driverMode;
        this.disableSubmitOptimization = line.hasOption(CliFrontendParser.DISABLE_SUBMIT_OPTIMIZATION.getOpt());
        if (line.hasOption(CliFrontendParser.SAVEPOINT_PATH_OPTION.getOpt()) && line.hasOption(CliFrontendParser.RESUME_PATH_OPTION.getOpt())) {
            throw new CliArgsException("Please only offer either savepoint path or resume path.");
        }
        if (line.hasOption(CliFrontendParser.SAVEPOINT_PATH_OPTION.getOpt())) {
            String savepointPath = line.getOptionValue(CliFrontendParser.SAVEPOINT_PATH_OPTION.getOpt());
            allowNonRestoredState = line.hasOption(CliFrontendParser.SAVEPOINT_ALLOW_NON_RESTORED_OPTION.getOpt());
            this.savepointSettings = SavepointRestoreSettings.forPath((String)savepointPath, (boolean)allowNonRestoredState);
        } else if (line.hasOption(CliFrontendParser.RESUME_PATH_OPTION.getOpt())) {
            String checkpointPath = line.getOptionValue(CliFrontendParser.RESUME_PATH_OPTION.getOpt());
            allowNonRestoredState = line.hasOption(CliFrontendParser.SAVEPOINT_ALLOW_NON_RESTORED_OPTION.getOpt());
            this.savepointSettings = SavepointRestoreSettings.forResumePath((String)checkpointPath, (boolean)allowNonRestoredState);
        } else {
            this.savepointSettings = SavepointRestoreSettings.none();
        }
        this.libjars = this.extractMultipleURIOption(CliFrontendParser.LIBJARS_OPTION.getLongOpt(), line);
        this.files = this.extractMultipleURIOption(CliFrontendParser.FILES_OPTION.getLongOpt(), line);
    }

    public String getJarFilePath() {
        return this.jarFilePath;
    }

    public String getEntryPointClassName() {
        return this.entryPointClass;
    }

    public List<URL> getClasspaths() {
        return this.classpaths;
    }

    public String[] getProgramArgs() {
        return this.programArgs;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public boolean getStdoutLogging() {
        return this.stdoutLogging;
    }

    public boolean getDetachedMode() {
        return this.detachedMode;
    }

    public boolean isDriverMode() {
        return this.driverMode;
    }

    public boolean isSubmitOptimizationDisabled() {
        return this.disableSubmitOptimization;
    }

    public SavepointRestoreSettings getSavepointRestoreSettings() {
        return this.savepointSettings;
    }

    public List<URI> getLibjars() {
        return this.libjars;
    }

    public List<URI> getFiles() {
        return this.files;
    }

    public Boolean isPython() {
        return this.isPython;
    }

    private List<URI> extractMultipleURIOption(String opt, CommandLine line) throws CliArgsException {
        ArrayList<URI> uris = new ArrayList<URI>();
        if (line.hasOption(opt)) {
            for (String items : line.getOptionValues(opt)) {
                if (StringUtils.isEmpty((CharSequence)items)) continue;
                for (String item : items.split(",")) {
                    try {
                        URI uri = new URI(item);
                        uris.add(uri.isAbsolute() ? uri : new URI("file://" + item));
                    }
                    catch (URISyntaxException e) {
                        throw new CliArgsException("Bad syntax for URI: " + item);
                    }
                }
            }
        }
        return uris;
    }
}

