/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.client.program;

import org.apache.flink.api.common.JobSubmissionResult;
import org.apache.flink.api.java.ExecutionEnvironmentFactory;
import org.apache.flink.runtime.jobgraph.SavepointRestoreSettings;

import java.net.URI;
import java.net.URL;
import java.util.List;

/**
 * A ContextEnvironment for DataSet execution in driver mode.
 */
public class DriverContextEnvironment extends ContextEnvironment {
	private String driverName;

	public DriverContextEnvironment(ClusterClient client, String driverId, List<URL> jarFiles,
									List<URL> globalClassPaths, List<URI> libJars, List<URI> externalFiles, ClassLoader userCodeClassLoader, SavepointRestoreSettings savepointRestoreSettings) throws Exception {
		super(client, jarFiles, globalClassPaths, libJars, externalFiles, userCodeClassLoader, savepointRestoreSettings);
		this.driverName = driverId;
	}

	public void setAsContext() {
		ExecutionEnvironmentFactory factory = () -> DriverContextEnvironment.this;
		initializeContextEnvironment(factory);
	}

	@Override
	public JobSubmissionResult executeInternal(String jobName, boolean detached) throws Exception {
		String newJobName = driverName + "_" + jobName;
		return super.executeInternal(newJobName, detached);
	}
}
