/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.cli;

import org.apache.commons.cli.CommandLine;
import org.apache.flink.client.cli.CliFrontendParser;
import org.apache.flink.client.cli.CommandLineOptions;
import org.apache.flink.util.Preconditions;

public class StopOptions
extends CommandLineOptions {
    private final String[] args;
    private final boolean checkpointFlag;
    private final boolean savepointFlag;
    private final String targetDirectory;
    private final boolean advanceToEndOfEventTime;

    public StopOptions(CommandLine line) {
        super(line);
        this.args = line.getArgs();
        this.checkpointFlag = line.hasOption(CliFrontendParser.STOP_WITH_CHECKPOINT.getOpt());
        this.savepointFlag = line.hasOption(CliFrontendParser.STOP_WITH_SAVEPOINT.getOpt());
        this.targetDirectory = line.getOptionValue(CliFrontendParser.STOP_WITH_SAVEPOINT.getOpt());
        this.advanceToEndOfEventTime = line.hasOption(CliFrontendParser.STOP_AND_DRAIN.getOpt());
        Preconditions.checkState((!this.savepointFlag || !this.checkpointFlag ? 1 : 0) != 0, (Object)"Can only stop with checkpoint and savepoint only.");
    }

    public String[] getArgs() {
        return this.args == null ? new String[]{} : this.args;
    }

    boolean hasSavepointFlag() {
        return this.savepointFlag;
    }

    boolean hasCheckpointFlag() {
        return this.checkpointFlag;
    }

    String getTargetDirectory() {
        return this.targetDirectory;
    }

    boolean shouldAdvanceToEndOfEventTime() {
        return this.advanceToEndOfEventTime;
    }
}

