/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.program;

import java.net.URI;
import java.net.URL;
import java.util.List;
import org.apache.flink.api.common.JobSubmissionResult;
import org.apache.flink.api.java.ExecutionEnvironmentFactory;
import org.apache.flink.client.program.ClusterClient;
import org.apache.flink.client.program.ContextEnvironment;
import org.apache.flink.runtime.jobgraph.SavepointRestoreSettings;

public class DriverContextEnvironment
extends ContextEnvironment {
    private String driverName;

    public DriverContextEnvironment(ClusterClient client, String driverId, List<URL> jarFiles, List<URL> globalClassPaths, List<URI> libJars, List<URI> externalFiles, ClassLoader userCodeClassLoader, SavepointRestoreSettings savepointRestoreSettings) throws Exception {
        super(client, jarFiles, globalClassPaths, libJars, externalFiles, userCodeClassLoader, savepointRestoreSettings);
        this.driverName = driverId;
    }

    public void setAsContext() {
        ExecutionEnvironmentFactory factory = () -> this;
        DriverContextEnvironment.initializeContextEnvironment((ExecutionEnvironmentFactory)factory);
    }

    @Override
    public JobSubmissionResult executeInternal(String jobName, boolean detached) throws Exception {
        String newJobName = this.driverName + "_" + jobName;
        return super.executeInternal(newJobName, detached);
    }
}

