/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.program;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.Plan;
import org.apache.flink.runtime.execution.librarycache.FlinkUserCodeClassLoaders;

public class JobWithJars {
    private Plan plan;
    private List<URL> jarFiles;
    private final List<URI> libjars;
    private final List<URI> files;
    private List<URL> classpaths;
    private ClassLoader userCodeClassLoader;

    public JobWithJars(Plan plan, List<URL> jarFiles, List<URL> classpaths) throws IOException {
        this(plan, jarFiles, classpaths, Collections.emptyList(), Collections.emptyList());
    }

    public JobWithJars(Plan plan, List<URL> jarFiles, List<URL> classpaths, List<URI> libjars, List<URI> files) throws IOException {
        this.plan = plan;
        this.jarFiles = new ArrayList<URL>(jarFiles.size());
        this.classpaths = new ArrayList<URL>(classpaths.size());
        for (URL jarFile : jarFiles) {
            JobWithJars.checkJarFile(jarFile);
            this.jarFiles.add(jarFile);
        }
        for (URL path : classpaths) {
            this.classpaths.add(path);
        }
        this.libjars = libjars;
        this.files = files;
    }

    public JobWithJars(Plan plan, URL jarFile) throws IOException {
        this.plan = plan;
        JobWithJars.checkJarFile(jarFile);
        this.jarFiles = Collections.singletonList(jarFile);
        this.classpaths = Collections.emptyList();
        this.libjars = Collections.emptyList();
        this.files = Collections.emptyList();
    }

    JobWithJars(Plan plan, List<URL> jarFiles, List<URL> classpaths, List<URI> libjars, List<URI> files, ClassLoader userCodeClassLoader) {
        this.plan = plan;
        this.jarFiles = jarFiles;
        this.classpaths = classpaths;
        this.libjars = libjars;
        this.files = files;
        this.userCodeClassLoader = userCodeClassLoader;
    }

    public Plan getPlan() {
        return this.plan;
    }

    public List<URL> getJarFiles() {
        return this.jarFiles;
    }

    public List<URL> getClasspaths() {
        return this.classpaths;
    }

    public List<URI> getLibjars() {
        return this.libjars;
    }

    public List<URI> getFiles() {
        return this.files;
    }

    public ClassLoader getUserCodeClassLoader() {
        if (this.userCodeClassLoader == null) {
            this.userCodeClassLoader = JobWithJars.buildUserCodeClassLoader(this.jarFiles, this.classpaths, this.getClass().getClassLoader());
        }
        return this.userCodeClassLoader;
    }

    public static void checkJarFile(URL jar) throws IOException {
        File jarFile;
        try {
            jarFile = new File(jar.toURI());
        }
        catch (URISyntaxException e) {
            throw new IOException("JAR file path is invalid '" + jar + "'");
        }
        if (!jarFile.exists()) {
            throw new IOException("JAR file does not exist '" + jarFile.getAbsolutePath() + "'");
        }
        if (!jarFile.canRead()) {
            throw new IOException("JAR file can't be read '" + jarFile.getAbsolutePath() + "'");
        }
    }

    public static ClassLoader buildUserCodeClassLoader(List<URL> jars, List<URL> classpaths, ClassLoader parent) {
        int i;
        URL[] urls = new URL[jars.size() + classpaths.size()];
        for (i = 0; i < jars.size(); ++i) {
            urls[i] = jars.get(i);
        }
        for (i = 0; i < classpaths.size(); ++i) {
            urls[i + jars.size()] = classpaths.get(i);
        }
        return FlinkUserCodeClassLoaders.parentFirst((URL[])urls, (ClassLoader)parent);
    }
}

