/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.program;

import java.net.InetSocketAddress;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobSubmissionResult;
import org.apache.flink.client.deployment.StandaloneClusterId;
import org.apache.flink.client.program.ClusterClient;
import org.apache.flink.client.program.ProgramInvocationException;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.WebOptions;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.clusterframework.messages.GetClusterStatus;
import org.apache.flink.runtime.clusterframework.messages.GetClusterStatusResponse;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.instance.ActorGateway;
import org.apache.flink.runtime.jobgraph.JobGraph;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;

public class StandaloneClusterClient
extends ClusterClient<StandaloneClusterId> {
    public StandaloneClusterClient(Configuration config) throws Exception {
        super(config);
    }

    public StandaloneClusterClient(Configuration config, HighAvailabilityServices highAvailabilityServices, boolean sharedHaServices) {
        super(config, highAvailabilityServices, sharedHaServices);
    }

    @Override
    public void waitForClusterToBeReady() {
    }

    @Override
    public String getWebInterfaceURL() {
        InetSocketAddress inetSocketAddressFromAkkaURL;
        try {
            inetSocketAddressFromAkkaURL = AkkaUtils.getInetSocketAddressFromAkkaURL((String)this.getClusterConnectionInfo().getAddress());
        }
        catch (Exception e) {
            throw new RuntimeException("Could not retrieve leader retrieval information.", e);
        }
        String host = inetSocketAddressFromAkkaURL.getHostName();
        int port = this.getFlinkConfiguration().getInteger(WebOptions.PORT);
        return "http://" + host + ":" + port;
    }

    @Override
    public GetClusterStatusResponse getClusterStatus() {
        try {
            ActorGateway jmGateway = this.getJobManagerGateway();
            Future future = jmGateway.ask((Object)GetClusterStatus.getInstance(), this.timeout);
            Object result = Await.result((Awaitable)future, (Duration)this.timeout);
            if (result instanceof GetClusterStatusResponse) {
                return (GetClusterStatusResponse)result;
            }
            throw new RuntimeException("Received the wrong reply " + result + " from cluster.");
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't retrieve the cluster status.", e);
        }
    }

    @Override
    public List<String> getNewMessages() {
        return Collections.emptyList();
    }

    @Override
    public StandaloneClusterId getClusterId() {
        return StandaloneClusterId.getInstance();
    }

    @Override
    public int getMaxSlots() {
        return -1;
    }

    @Override
    public boolean hasUserJarsInClassPath(List<URL> userJarFiles) {
        return false;
    }

    @Override
    public JobSubmissionResult submitJob(JobGraph jobGraph, ClassLoader classLoader, boolean detached) throws ProgramInvocationException {
        if (this.isDetached() || this.isDetached()) {
            return super.runDetached(jobGraph, classLoader);
        }
        return super.run(jobGraph, classLoader);
    }

    @Override
    public String stopWithCheckpoint(JobID jobId, boolean isSavepoint, boolean advanceToEndOfEventTime, @Nullable String savepointDirectory) {
        throw new UnsupportedOperationException("Do not support stop with checkpoint for stand alone cluster.");
    }
}

