/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.io;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.java.io.CsvInputFormat;
import org.apache.flink.api.java.typeutils.TupleTypeInfoBase;
import org.apache.flink.api.java.typeutils.runtime.TupleSerializerBase;
import org.apache.flink.core.fs.Path;

@Internal
public class TupleCsvInputFormat<OUT>
extends CsvInputFormat<OUT> {
    private static final long serialVersionUID = 1L;
    private TupleSerializerBase<OUT> tupleSerializer;
    private TupleTypeInfoBase<OUT> tupleTypeInfo;

    public TupleCsvInputFormat(Path filePath, TupleTypeInfoBase<OUT> tupleTypeInfo) {
        this(filePath, "\n", ",", tupleTypeInfo);
    }

    public TupleCsvInputFormat(Path filePath, String lineDelimiter, String fieldDelimiter, TupleTypeInfoBase<OUT> tupleTypeInfo) {
        this(filePath, lineDelimiter, fieldDelimiter, tupleTypeInfo, TupleCsvInputFormat.createDefaultMask(tupleTypeInfo.getArity()));
    }

    public TupleCsvInputFormat(Path filePath, TupleTypeInfoBase<OUT> tupleTypeInfo, int[] includedFieldsMask) {
        this(filePath, "\n", ",", tupleTypeInfo, includedFieldsMask);
    }

    public TupleCsvInputFormat(Path filePath, String lineDelimiter, String fieldDelimiter, TupleTypeInfoBase<OUT> tupleTypeInfo, int[] includedFieldsMask) {
        super(filePath);
        boolean[] mask = includedFieldsMask == null ? TupleCsvInputFormat.createDefaultMask(tupleTypeInfo.getArity()) : TupleCsvInputFormat.toBooleanMask(includedFieldsMask);
        this.configure(lineDelimiter, fieldDelimiter, tupleTypeInfo, mask);
    }

    public TupleCsvInputFormat(Path filePath, TupleTypeInfoBase<OUT> tupleTypeInfo, boolean[] includedFieldsMask) {
        this(filePath, "\n", ",", tupleTypeInfo, includedFieldsMask);
    }

    public TupleCsvInputFormat(Path filePath, String lineDelimiter, String fieldDelimiter, TupleTypeInfoBase<OUT> tupleTypeInfo, boolean[] includedFieldsMask) {
        super(filePath);
        this.configure(lineDelimiter, fieldDelimiter, tupleTypeInfo, includedFieldsMask);
    }

    private void configure(String lineDelimiter, String fieldDelimiter, TupleTypeInfoBase<OUT> tupleTypeInfo, boolean[] includedFieldsMask) {
        if (tupleTypeInfo.getArity() == 0) {
            throw new IllegalArgumentException("Tuple size must be greater than 0.");
        }
        if (includedFieldsMask == null) {
            includedFieldsMask = TupleCsvInputFormat.createDefaultMask(tupleTypeInfo.getArity());
        }
        this.tupleTypeInfo = tupleTypeInfo;
        this.tupleSerializer = (TupleSerializerBase)tupleTypeInfo.createSerializer(new ExecutionConfig());
        this.setDelimiter(lineDelimiter);
        this.setFieldDelimiter(fieldDelimiter);
        Class[] classes = new Class[tupleTypeInfo.getArity()];
        for (int i = 0; i < tupleTypeInfo.getArity(); ++i) {
            classes[i] = tupleTypeInfo.getTypeAt(i).getTypeClass();
        }
        this.setFieldsGeneric(includedFieldsMask, classes);
    }

    @Override
    public OUT fillRecord(OUT reuse, Object[] parsedValues) {
        return (OUT)this.tupleSerializer.createOrReuseInstance(parsedValues, reuse);
    }

    public TupleTypeInfoBase<OUT> getTupleTypeInfo() {
        return this.tupleTypeInfo;
    }
}

