/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.io;

import java.io.IOException;
import java.util.Arrays;
import org.apache.flink.api.common.io.ParseException;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.io.CsvInputFormat;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.core.fs.Path;
import org.apache.flink.types.parser.FieldParser;

public abstract class AbstractRowCsvInputFormat<T>
extends CsvInputFormat<T>
implements ResultTypeQueryable<T> {
    protected int arity;
    protected TypeInformation[] fieldTypeInfos;
    private int[] fieldPosMap;
    private boolean emptyColumnAsNull;
    private long limit;
    private long currentConsumeRowCount;

    public AbstractRowCsvInputFormat(Path filePath, TypeInformation[] fieldTypeInfos, String lineDelimiter, String fieldDelimiter, int[] selectedFields, boolean emptyColumnAsNull, long limit) {
        super(filePath);
        this.arity = fieldTypeInfos.length;
        if (this.arity == 0) {
            throw new IllegalArgumentException("At least one field must be specified");
        }
        if (this.arity != selectedFields.length) {
            throw new IllegalArgumentException("Number of field types and selected fields must be the same");
        }
        this.fieldTypeInfos = fieldTypeInfos;
        this.fieldPosMap = AbstractRowCsvInputFormat.toFieldPosMap(selectedFields);
        this.emptyColumnAsNull = emptyColumnAsNull;
        this.limit = limit;
        this.currentConsumeRowCount = 0L;
        boolean[] fieldsMask = AbstractRowCsvInputFormat.toFieldMask(selectedFields);
        this.setDelimiter(lineDelimiter);
        this.setFieldDelimiter(fieldDelimiter);
        this.setFieldsGeneric(fieldsMask, AbstractRowCsvInputFormat.extractTypeClasses(fieldTypeInfos));
    }

    @Override
    public T nextRecord(T record) throws IOException {
        T ret = super.nextRecord(record);
        if (ret != null) {
            ++this.currentConsumeRowCount;
        }
        return ret;
    }

    public boolean reachedEnd() {
        return super.reachedEnd() || this.currentConsumeRowCount >= this.limit;
    }

    private static Class<?>[] extractTypeClasses(TypeInformation[] fieldTypes) {
        Class[] classes = new Class[fieldTypes.length];
        for (int i = 0; i < fieldTypes.length; ++i) {
            classes[i] = fieldTypes[i].getTypeClass();
        }
        return classes;
    }

    private static boolean[] toFieldMask(int[] selectedFields) {
        int maxField = 0;
        for (int selectedField : selectedFields) {
            maxField = Math.max(maxField, selectedField);
        }
        boolean[] mask = new boolean[maxField + 1];
        Arrays.fill(mask, false);
        for (int selectedField : selectedFields) {
            mask[selectedField] = true;
        }
        return mask;
    }

    private static int[] toFieldPosMap(int[] selectedFields) {
        int[] fieldIdxs = Arrays.copyOf(selectedFields, selectedFields.length);
        Arrays.sort(fieldIdxs);
        int[] fieldPosMap = new int[selectedFields.length];
        int i = 0;
        while (i < selectedFields.length) {
            int pos = Arrays.binarySearch(fieldIdxs, selectedFields[i]);
            fieldPosMap[pos] = i++;
        }
        return fieldPosMap;
    }

    protected boolean parseRecord(Object[] holders, byte[] bytes, int offset, int numBytes) throws ParseException {
        byte[] fieldDelimiter = this.getFieldDelimiter();
        boolean[] fieldIncluded = this.fieldIncluded;
        int startPos = offset;
        int limit = offset + numBytes;
        int output = 0;
        for (int field = 0; field < fieldIncluded.length; ++field) {
            if (startPos > limit || startPos == limit && field != fieldIncluded.length - 1) {
                if (this.isLenient()) {
                    return false;
                }
                throw new ParseException("Row too short: " + new String(bytes, offset, numBytes, this.getCharset()));
            }
            if (fieldIncluded[field]) {
                FieldParser parser = this.getFieldParsers()[this.fieldPosMap[output]];
                int latestValidPos = startPos;
                startPos = parser.resetErrorStateAndParse(bytes, startPos, limit, fieldDelimiter, holders[this.fieldPosMap[output]], this.emptyColumnAsNull);
                if (!this.isLenient() && parser.getErrorState() != FieldParser.ParseErrorState.NONE && parser.getErrorState() != FieldParser.ParseErrorState.EMPTY_COLUMN) {
                    throw new ParseException(String.format("Parsing error for column %1$s of row '%2$s' originated by %3$s: %4$s.", field, new String(bytes, offset, numBytes), parser.getClass().getSimpleName(), parser.getErrorState()));
                }
                if (startPos < 0 || this.emptyColumnAsNull && parser.getErrorState().equals((Object)FieldParser.ParseErrorState.EMPTY_COLUMN)) {
                    holders[this.fieldPosMap[output]] = null;
                    startPos = this.skipFields(bytes, latestValidPos, limit, fieldDelimiter);
                } else {
                    holders[this.fieldPosMap[output]] = parser.getLastResult();
                }
                ++output;
            } else {
                startPos = this.skipFields(bytes, startPos, limit, fieldDelimiter);
            }
            if (startPos < 0) {
                throw new ParseException(String.format("Unexpected parser position for column %1$s of row '%2$s'", field, new String(bytes, offset, numBytes)));
            }
            if (startPos != limit || field == fieldIncluded.length - 1 || FieldParser.endsWithDelimiter((byte[])bytes, (int)(startPos - 1), (byte[])fieldDelimiter)) continue;
            if (this.isLenient()) {
                return false;
            }
            throw new ParseException("Row too short: " + new String(bytes, offset, numBytes));
        }
        return true;
    }
}

