/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.io;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.io.AbstractRowCsvInputFormat;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.core.fs.Path;
import org.apache.flink.types.Row;

@PublicEvolving
public class RowCsvInputFormat
extends AbstractRowCsvInputFormat<Row> {
    private static final long serialVersionUID = 1L;

    public RowCsvInputFormat(Path filePath, TypeInformation[] fieldTypeInfos, String lineDelimiter, String fieldDelimiter, int[] selectedFields, boolean emptyColumnAsNull, long limit) {
        super(filePath, fieldTypeInfos, lineDelimiter, fieldDelimiter, selectedFields, emptyColumnAsNull, limit);
    }

    public RowCsvInputFormat(Path filePath, TypeInformation[] fieldTypeInfos, String lineDelimiter, String fieldDelimiter, int[] selectedFields, boolean emptyColumnAsNull) {
        this(filePath, fieldTypeInfos, lineDelimiter, fieldDelimiter, selectedFields, emptyColumnAsNull, Long.MAX_VALUE);
    }

    public RowCsvInputFormat(Path filePath, TypeInformation[] fieldTypes, String lineDelimiter, String fieldDelimiter, int[] selectedFields) {
        this(filePath, fieldTypes, lineDelimiter, fieldDelimiter, selectedFields, false, Long.MAX_VALUE);
    }

    public RowCsvInputFormat(Path filePath, TypeInformation[] fieldTypes, String lineDelimiter, String fieldDelimiter) {
        this(filePath, fieldTypes, lineDelimiter, fieldDelimiter, RowCsvInputFormat.sequentialScanOrder(fieldTypes.length));
    }

    public RowCsvInputFormat(Path filePath, TypeInformation[] fieldTypes, int[] selectedFields) {
        this(filePath, fieldTypes, "\n", ",", selectedFields);
    }

    public RowCsvInputFormat(Path filePath, TypeInformation[] fieldTypes, boolean emptyColumnAsNull) {
        this(filePath, fieldTypes, "\n", ",", RowCsvInputFormat.sequentialScanOrder(fieldTypes.length), emptyColumnAsNull, Long.MAX_VALUE);
    }

    public RowCsvInputFormat(Path filePath, TypeInformation[] fieldTypes) {
        this(filePath, fieldTypes, false);
    }

    private static int[] sequentialScanOrder(int arity) {
        int[] sequentialOrder = new int[arity];
        for (int i = 0; i < arity; ++i) {
            sequentialOrder[i] = i;
        }
        return sequentialOrder;
    }

    @Override
    protected Row fillRecord(Row reuse, Object[] parsedValues) {
        Row reuseRow = reuse == null ? new Row(this.arity) : reuse;
        for (int i = 0; i < parsedValues.length; ++i) {
            reuseRow.setField(i, parsedValues[i]);
        }
        return reuseRow;
    }

    public TypeInformation<Row> getProducedType() {
        return new RowTypeInfo(this.fieldTypeInfos);
    }
}

