/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.queryablestate.client.state;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.state.SortedMapState;
import org.apache.flink.api.common.state.SortedMapStateDescriptor;
import org.apache.flink.queryablestate.client.state.ImmutableState;
import org.apache.flink.queryablestate.client.state.serialization.KvStateSerializer;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class ImmutableSortedMapState<K, V>
extends ImmutableState
implements SortedMapState<K, V> {
    private final SortedMap<K, V> state;

    private ImmutableSortedMapState(SortedMap<K, V> maps) {
        this.state = (SortedMap)Preconditions.checkNotNull(maps);
    }

    public V get(K key) {
        return this.state.get(key);
    }

    public void put(K key, V value) {
        throw MODIFICATION_ATTEMPT_ERROR;
    }

    public void remove(K key) {
        throw MODIFICATION_ATTEMPT_ERROR;
    }

    public boolean contains(K key) {
        return this.state.containsKey(key);
    }

    public Iterable<Map.Entry<K, V>> entries() {
        return Collections.unmodifiableSet(this.state.entrySet());
    }

    public Iterable<K> keys() {
        return Collections.unmodifiableSet(this.state.keySet());
    }

    public Iterable<V> values() {
        return Collections.unmodifiableCollection(this.state.values());
    }

    public Iterator<Map.Entry<K, V>> iterator() {
        return Collections.unmodifiableSet(this.state.entrySet()).iterator();
    }

    public Map.Entry<K, V> firstEntry() {
        return new Map.Entry<K, V>(){

            @Override
            public K getKey() {
                return ImmutableSortedMapState.this.state.firstKey();
            }

            @Override
            public V getValue() {
                return ImmutableSortedMapState.this.state.get(ImmutableSortedMapState.this.state.firstKey());
            }

            @Override
            public V setValue(V value) {
                return ImmutableSortedMapState.this.state.put(ImmutableSortedMapState.this.state.firstKey(), value);
            }
        };
    }

    public Map.Entry<K, V> lastEntry() {
        return new Map.Entry<K, V>(){

            @Override
            public K getKey() {
                return ImmutableSortedMapState.this.state.lastKey();
            }

            @Override
            public V getValue() {
                return ImmutableSortedMapState.this.state.get(ImmutableSortedMapState.this.state.lastKey());
            }

            @Override
            public V setValue(V value) {
                return ImmutableSortedMapState.this.state.put(ImmutableSortedMapState.this.state.lastKey(), value);
            }
        };
    }

    public Iterator<Map.Entry<K, V>> headIterator(K endKey) {
        return Collections.unmodifiableSet(this.state.headMap(endKey).entrySet()).iterator();
    }

    public Iterator<Map.Entry<K, V>> tailIterator(K startKey) {
        return Collections.unmodifiableSet(this.state.tailMap(startKey).entrySet()).iterator();
    }

    public Iterator<Map.Entry<K, V>> subIterator(K startKey, K endKey) {
        return Collections.unmodifiableSet(this.state.subMap(startKey, endKey).entrySet()).iterator();
    }

    public void putAll(Map<K, V> map) {
        throw MODIFICATION_ATTEMPT_ERROR;
    }

    public void clear() {
        throw MODIFICATION_ATTEMPT_ERROR;
    }

    public static <K, V> ImmutableSortedMapState<K, V> createState(SortedMapStateDescriptor<K, V> stateDescriptor, byte[] serializedState) throws IOException {
        Map deserializeMap = KvStateSerializer.deserializeMap(serializedState, stateDescriptor.getKeySerializer(), stateDescriptor.getValueSerializer());
        TreeMap state = new TreeMap(deserializeMap);
        return new ImmutableSortedMapState(state);
    }
}

