/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.runtime.healthmanager.plugins.utils;

import org.apache.flink.runtime.jobgraph.JobVertexID;

/**
 * Task metrics.
 */
public class TaskMetrics {
	private final JobVertexID jobVertexID;
	private final boolean isParallelSource;
	private final double inputTps;
	private final double outputTps;
	private final double timerCount;
	private final double taskLatencyPerRecord;
	private final double sourceLatencyPerRecord;
	private final double waitOutputPerRecord;
	private final double workload;
	private final double delayIncreasingRate;
	private final double partitionLatency;
	private final double partitionCount;
	private final double maxInputTpsPerMinute;

	public TaskMetrics(
			JobVertexID jobVertexId,
			boolean isParallelSource,
			double inputTps,
			double maxInputTpsPerMinute,
			double outputTps,
			double timerCount,
			double taskLatencyPerRecord,
			double sourceLatencyPerRecord,
			double waitOutputPerRecord,
			double workload,
			double delayIncreasingRate,
			double partitionLatency,
			double partitionCount) {

		this.jobVertexID = jobVertexId;
		this.maxInputTpsPerMinute = maxInputTpsPerMinute;
		this.isParallelSource = isParallelSource;
		this.inputTps = inputTps;
		this.outputTps = outputTps;
		this.timerCount = timerCount;
		this.taskLatencyPerRecord = taskLatencyPerRecord;
		this.sourceLatencyPerRecord = sourceLatencyPerRecord;
		this.waitOutputPerRecord = waitOutputPerRecord;
		this.workload = workload;
		this.delayIncreasingRate = delayIncreasingRate;
		this.partitionLatency =  partitionLatency;
		this.partitionCount = partitionCount;
	}

	public TaskMetrics(
		JobVertexID jobVertexId,
		boolean isParallelSource,
		double inputTps,
		double outputTps,
		double timerCount,
		double taskLatencyPerRecord,
		double sourceLatencyPerRecord,
		double waitOutputPerRecord,
		double workload,
		double delayIncreasingRate,
		double partitionLatency,
		double partitionCount) {

		this(jobVertexId, isParallelSource, inputTps, 0, outputTps, timerCount,
				taskLatencyPerRecord, sourceLatencyPerRecord, waitOutputPerRecord, workload, delayIncreasingRate,
				partitionLatency, partitionCount);
	}

	public JobVertexID getJobVertexID() {
		return jobVertexID;
	}

	public double getInputTps() {
		return inputTps;
	}

	public double getOutputTps() {
		return outputTps;
	}

	public double getTimerCount() {
		return timerCount;
	}

	public double getTaskLatencyPerRecord() {
		return taskLatencyPerRecord;
	}

	public double getSourceLatencyPerRecord() {
		return sourceLatencyPerRecord;
	}

	public double getWaitOutputPerRecord() {
		return waitOutputPerRecord;
	}

	public double getWorkload() {
		return workload;
	}

	public boolean isParallelSource() {
		return isParallelSource;
	}

	public double getPartitionLatency() {
		return partitionLatency;
	}

	public double getPartitionCount() {
		return partitionCount;
	}

	@Override
	public String toString() {
		return "TaskMetrics{JobVertexID:" + jobVertexID
			+ ", isParallelSource:" + isParallelSource
			+ ", inputTps:" + inputTps
			+ ", maxInputTpsPerMinute:" + maxInputTpsPerMinute
			+ ", outputTps:" + outputTps
			+ ", timerCount:" + timerCount
			+ ", taskLatencyPerRecord:" + taskLatencyPerRecord
			+ ", sourceLatencyPerRecord:" + sourceLatencyPerRecord
			+ ", waitOutputPerRecord:" + waitOutputPerRecord
			+ ", workload:" + workload
			+ ", delayIncreasingRate:" + delayIncreasingRate
			+ ", partitionLatency:" + partitionLatency
			+ ", partitionCount:" + partitionCount + "}";
	}

	public double getDelayIncreasingRate() {
		return delayIncreasingRate;
	}

	public double getMaxInputTpsPerMinute() {
		return maxInputTpsPerMinute;
	}

}
