/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.runtime.io.network.partition.external;

import java.io.IOException;

import static
	org.apache.flink.runtime.io.network.partition.external.ExternalBlockResultPartitionMeta.ExternalSubpartitionMeta;

/**
 * The interface to load partition indices and provide subpartition metas.
 */
public interface PartitionIndices {

	/**
	 * Initializes {@code PartitionIndices} including loading partition indices from index file.
	 * @throws IOException
	 */
	void initialize() throws IOException ;

	/**
	 * Gets subpartition meta.
	 * @param subpartitionIndex the index of a specific subpartition
	 * @return subpartition meta specified by subpartitionIndex
	 * @throws Exception
	 */
	ExternalSubpartitionMeta getSubpartitionMeta(int subpartitionIndex) throws IOException;

	/**
	 * Shrink the memory footprint used by PartitionIndices if possible.
	 * @return the size of memory footprint shrunk
	 */
	long shrinkMemoryFootprint();

	/**
	 * Gets the size of memory footprint that can be shrunk.
	 * @return the size of memory footprint that can be shrunk
	 */
	long getShrinkableMemoryFootprint();
}
