/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.runtime.rest.messages;

import org.apache.flink.runtime.rest.handler.cluster.TotalResourceLimitHandler;

import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;

import java.util.Map;
import java.util.Objects;

/**
 * Response type of the {@link TotalResourceLimitHandler}.
 */
public class TotalResourceLimitInfos implements ResponseBody {

	private static final String FIELD_NAME_RESOURCE_LIMIT = "resource-limits";

	@JsonProperty(FIELD_NAME_RESOURCE_LIMIT)
	private final Map<Long, Exception> resourceLimit;

	@JsonCreator
	public TotalResourceLimitInfos(@JsonProperty(FIELD_NAME_RESOURCE_LIMIT) Map<Long, Exception> resourceLimit) {
		this.resourceLimit = resourceLimit;
	}

	@JsonIgnore
	public Map<Long, Exception> getResourceLimit() {
		return resourceLimit;
	}

	@Override
	public boolean equals(Object o) {
		if (this == o) {
			return true;
		}
		if (o == null || getClass() != o.getClass()) {
			return false;
		}
		TotalResourceLimitInfos that = (TotalResourceLimitInfos) o;
		return Objects.equals(resourceLimit, that.resourceLimit);
	}

	@Override
	public int hashCode() {
		return Objects.hash(resourceLimit);
	}

}
