/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.runtime.rest.messages.taskmanager;

import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.runtime.rest.messages.job.SubtaskExecutionAttemptInfo;

import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;

import java.util.Collection;
import java.util.Objects;

/**
 * The sub task execution attempt response for taskmanager.
 */
public class TaskManagerSubtaskCurrentAttemptsInfo implements ResponseBody {

	public static final String FIELD_NAME_SUBTASKS_INFO = "subtasks";

	@JsonProperty(FIELD_NAME_SUBTASKS_INFO)
	private final Collection<SubtaskExecutionAttemptInfo> subtaskExecutionAttemptsInfo;

	@JsonCreator
	public TaskManagerSubtaskCurrentAttemptsInfo(
		@JsonProperty(FIELD_NAME_SUBTASKS_INFO) Collection<SubtaskExecutionAttemptInfo> subtaskExecutionAttemptsInfo) {

		this.subtaskExecutionAttemptsInfo = subtaskExecutionAttemptsInfo;
	}

	@JsonIgnore
	public Collection<SubtaskExecutionAttemptInfo> getSubtaskInfos() {
		return subtaskExecutionAttemptsInfo;
	}

	@Override
	public boolean equals(Object o) {
		if (this == o) {
			return true;
		}
		if (o == null || getClass() != o.getClass()) {
			return false;
		}

		TaskManagerSubtaskCurrentAttemptsInfo that = (TaskManagerSubtaskCurrentAttemptsInfo) o;

		return Objects.equals(subtaskExecutionAttemptsInfo, that.subtaskExecutionAttemptsInfo);
	}

	@Override
	public int hashCode() {
		return Objects.hash(subtaskExecutionAttemptsInfo);
	}

}
