/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.runtime.state.gemini.engine;

import org.apache.flink.shaded.guava18.com.google.common.base.MoreObjects;

import java.util.concurrent.atomic.AtomicInteger;

/**
 * Status will be used in ExceptionMetrics.
 */
public class ExceptionStat {
	private AtomicInteger totalFileException;

	private AtomicInteger totalFileWriterException;

	public ExceptionStat() {
		this.totalFileException = new AtomicInteger(0);
		this.totalFileWriterException = new AtomicInteger(0);
	}

	public int addTotalWriterException(int delta) {
		return this.totalFileException.addAndGet(delta);
	}

	public int addTotalFileWriterShift(int delta) {
		return this.totalFileWriterException.addAndGet(delta);
	}

	@Override
	public String toString() {
		return MoreObjects.toStringHelper(this).
			add("totalFileException", totalFileException.get()).
			add("totalFileWriterException", totalFileWriterException.get()).
			toString();
	}
}

