/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.runtime.state.gemini.engine;

/**
 * GRegionID.
 */
public interface GRegionID {
	/**
	 * Gemini reserve 1~7 as internal index id. so if custom index which may be supported in future will start from 8 to 255.
	 */
	int G_INDEX_BIT = 24;
	int G_REGION_ID_MARK = 0xFF_FF_FF;
	int G_REGION_DATA = 0;
	int G_REGION_INDEX_1 = 1;

	/**
	 * 1 byte for index ID; 3 bytes for region id.
	 *
	 * @return codedNum for this region.
	 */
	int getRegionCode();

	/**
	 * @return regionID
	 */
	int getId();

	/**
	 * @return 0 if this region is for data. 1~7 are used by gemini internally. 8~255 are used by customer in future.
	 * TODO we will add a map for id to index name in future. now only used id.
	 */
	int getIndexID();
}
