/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.runtime.state.gemini.engine;

import static org.apache.flink.util.Preconditions.checkNotNull;

/**
 * GeminiPKey2.
 */
public class GeminiPKey2<K0, K1> implements GeminiPKey {
	private final K0 firstKey;
	private final K1 secondKey;
	public GeminiPKey2(K0 key0, K1 key1) {
		firstKey = checkNotNull(key0);
		secondKey = key1;
	}

	public K0 getFirstKey() {
		return firstKey;
	}

	public K1 getSecondKey() {
		return secondKey;
	}

	@Override
	public boolean equals(Object obj) {
		if (obj == this) {
			return true;
		}

		if (!(obj instanceof GeminiPKey2)) {
			return false;
		}

		GeminiPKey2 other = (GeminiPKey2) obj;
		return firstKey.equals(other.firstKey) && secondKey.equals(other.secondKey);
	}

	@Override
	public int hashCode() {
		return firstKey.hashCode() + 31 * secondKey.hashCode();
	}

	@Override
	public String toString() {
		return "GeminiPKey2{" + "first=" + firstKey + "second" + secondKey + "}";
	}
}
