/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.runtime.state.gemini.engine.dbms;

import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.state.gemini.engine.GConfiguration;
import org.apache.flink.runtime.state.gemini.engine.GeminiDB;
import org.apache.flink.runtime.state.gemini.engine.filter.StateFilter;
import org.apache.flink.runtime.state.gemini.engine.metrics.CacheMetrics;
import org.apache.flink.runtime.state.gemini.engine.metrics.ExceptionMetrics;
import org.apache.flink.runtime.state.gemini.engine.metrics.FileCacheMetrics;
import org.apache.flink.runtime.state.gemini.engine.metrics.FileCleanerMetrics;
import org.apache.flink.runtime.state.gemini.engine.metrics.GeminiMetrics;
import org.apache.flink.runtime.state.gemini.engine.metrics.HandlerMetrics;
import org.apache.flink.runtime.state.gemini.engine.page.compress.GCompressAlgorithm;
import org.apache.flink.runtime.state.gemini.time.TimeProvider;

/**
 * GContext.
 */
public interface GContext {

	GeminiDB getGeminiDB();

	long getCurVersion();

	void increaseCurVersion();

	void setRestoredVersion(long version);

	long getRestoredVersion();

	int getStartRegionId();

	int getEndRegionId();

	Supervisor getSupervisor();

	void setSupervisor(Supervisor supervisor);

	GConfiguration getGConfiguration();

	void setDBMetricGroup(MetricGroup metricGroup);

	MetricGroup getDBMetricGroup();

	void setFileManagerMetricGroup(MetricGroup metricGroup);

	MetricGroup getFileManagerMetricGroup();

	void setGeminiMetric(GeminiMetrics geminiMetric);

	GeminiMetrics getGeminiMetric();

	void setCacheMetric(CacheMetrics cacheMetric);

	CacheMetrics getCacheMetric();

	void setHandlerMetric(HandlerMetrics handlerMetric);

	HandlerMetrics getHandlerMetric();

	void setFileCacheMetrics(FileCacheMetrics fileCacheMetrics);

	FileCacheMetrics getFileCacheMetrics();

	void setFileCleanerMetrics(FileCleanerMetrics fileCacheMetrics);

	FileCleanerMetrics getFileCleanerMetrics();

	void setExceptionMetrics(ExceptionMetrics exceptionMetrics);

	ExceptionMetrics getExceptionMetrics();

	void setTimeProvider(TimeProvider timeProvider);

	TimeProvider getTimeProvider();

	boolean hasTtl();

	boolean isExpired(long ts, long currentTime);

	void setStateFilter(StateFilter stateFilter);

	StateFilter getStateFilter();

	void incAccessNumber();

	long getAccessNumber();

	long incrementAndGetAccessNumber();

	/**
	 * we will record the access number when a snapshot is starting.
	 * This method will return the minimum snapshot access number of
	 * running snapshots.
	 */
	long getMinSnapshotAccessNumber();

	GCompressAlgorithm getInPageGCompressAlgorithm();

	GCompressAlgorithm getFlushWholePageGCompressAlgorithm();

	void setDBInternalError(Throwable throwable);

	/**
	 * Check the status of DB, and an exception will be throwed if DB is not running.
	 */
	void checkDBStatus();

	GeminiDB.Status getDBStatus();

	boolean isDBNormal();
}
