/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.runtime.state.gemini.engine.dbms;

import org.apache.flink.runtime.state.gemini.engine.GRegionContext;
import org.apache.flink.runtime.state.gemini.engine.GTable;
import org.apache.flink.runtime.state.gemini.engine.filecache.FileCache;
import org.apache.flink.runtime.state.gemini.engine.fs.FileCleaner;
import org.apache.flink.runtime.state.gemini.engine.fs.FileManager;
import org.apache.flink.runtime.state.gemini.engine.memstore.WriteBufferManager;
import org.apache.flink.runtime.state.gemini.engine.page.PageAddress;
import org.apache.flink.runtime.state.gemini.engine.rm.Allocator;
import org.apache.flink.runtime.state.gemini.engine.snapshot.BackendSnapshotMeta;
import org.apache.flink.runtime.state.gemini.engine.snapshot.SnapshotManager;
import org.apache.flink.runtime.state.gemini.engine.vm.CacheManager;
import org.apache.flink.runtime.state.gemini.engine.vm.FetchPolicy;

import org.apache.flink.shaded.netty4.io.netty.util.concurrent.EventExecutorGroup;

import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * GeminiSupervisor.
 */
public interface Supervisor {

	void start();

	void close();

	void startSnapshot(BackendSnapshotMeta backendSnapshotMeta) throws IOException;

	SnapshotManager.PendingSnapshot getPendingSnapshot(long checkpointId);

	Allocator getAllocator();

	Allocator getDefaultAllocator();

	Allocator getForReadAllocator();

	WriteBufferManager getWriteBufferManager();

	CacheManager getCacheManager();

	SnapshotManager getSnapshotManager();

	FileManager getLocalFileManager();

	FileManager getDfsFileManager();

	FileCache getFileCache();

	FileCleaner getFileCleaner();

	EventExecutorGroup getRegionExecutorGroup();

	EventExecutorGroup getFlushExecutorGroup();

	EventExecutorGroup getSnapshotExecutorGroup();

	EventExecutorGroup getCompactionExecutorGroup();

	void discardPage(GRegionContext gRegionContext, List<PageAddress> pageAddressList);

	Map<String, GTable> getAllTables();

	FetchPolicy getFetchPolicy();

	DiscardOrEvictPageReleaseManager getDiscardOrEvictPageReleaseManager();
}
