/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.runtime.state.gemini.engine.filter;

import org.apache.flink.runtime.state.gemini.engine.GRegionContext;

/**
 * Filter state when accessing and compacting state.
 * NOTE: we assume that if new version data should be filtered, then the old version
 * data should also be filtered.
 */
public interface StateFilter {

	/**
	 * Whether to filter a state with the gRegionContext and seqID.
	 *
	 * @return true if the state should be filtered.
	 */
	boolean filter(GRegionContext gRegionContext, long seqID);
}
