/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.runtime.state.gemini.engine.fs;

import org.apache.flink.shaded.guava18.com.google.common.base.MoreObjects;

import java.util.concurrent.atomic.AtomicInteger;

/**
 * Statistics for file cleaner.
 */
public class FileCleanerStat {

	private AtomicInteger totalReceivedFile;

	private AtomicInteger totalDeletedFile;

	private AtomicInteger totalFailedDeleteFiles;

	FileCleanerStat() {
		this.totalReceivedFile = new AtomicInteger(0);
		this.totalDeletedFile = new AtomicInteger(0);
		this.totalFailedDeleteFiles = new AtomicInteger(0);
	}

	public int addTotalReceivedFile(int delta) {
		return this.totalReceivedFile.addAndGet(delta);
	}

	public int addTotalDeletedFile(int delta) {
		return this.totalDeletedFile.addAndGet(delta);
	}

	public int addTotalFailedDeletedFiles(int delta) {
		return this.totalFailedDeleteFiles.addAndGet(delta);
	}

	@Override
	public String toString() {
		return MoreObjects.toStringHelper(this).
			add("totalReceivedFile", totalReceivedFile.get()).
			add("totalDeletedFile", totalDeletedFile.get()).
			add("totalFailedDeletedFiles", totalFailedDeleteFiles.get()).
			toString();
	}
}
