/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.runtime.state.gemini.engine.fs;

/**
 * Interface for file id.
 *
 * File id is composed as at least two parts, one part is unique id which would increase by one and other part(s)
 * is just for flag and would always stay the same.
 */
public interface FileID {

	/**
	 * Returns the current id of all the parts and return as a integer.
	 */
	int get();

	/**
	 * Returns the current unique id.
	 */
	int getUniqueID();

	/**
	 * Returns the max allowed unique id.
	 */
	int getMaxAllowedUniqueID();
}
