/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.runtime.state.gemini.engine.fs;

import java.io.IOException;

/**
 * FileWriter.
 */
public abstract class FileWriter extends GeminiDataOutputStream {

	public FileWriter(GeminiOutputStream geminiOutputStream) {
		super(geminiOutputStream);
	}

	/**
	 * Return the address by which we can
	 * find the file and data offset.
	 */
	public abstract long getAddress() throws IOException;

	/**
	 * Return the size of the file.
	 */
	public abstract long getSize() throws IOException;

	/**
	 * Return the file id this writer belongs to.
	 */
	public abstract FileID getFileID();

	/**
	 * Return the file path.
	 */
	public abstract String getFilePath();

	/**
	 * Increase the fail count of current file writer.
	 */
	public abstract void increasFailCount();

	/**
	 * Reset the fail count of current filw writer to zero.
	 */
	public abstract void resetFailCount();

	/**
	 * @return True if current FileWriter is valid, otherwise will return false.
	 */
	public abstract boolean isValid();
}
