/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.runtime.state.gemini.engine.handler;

import org.apache.flink.runtime.state.gemini.engine.dbms.GContext;

import org.apache.flink.shaded.netty4.io.netty.util.concurrent.SingleThreadEventExecutor;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.locks.LockSupport;

/**
 * GeminiEventExecutor.
 */
public final class GeminiEventExecutor extends SingleThreadEventExecutor {
	private ConcurrentLinkedQueue<Runnable> queue;
	private final long sleepTimeNs;

	private final GContext gContext;

	public GeminiEventExecutor(GeminiEventExecutorGroup parent, ThreadFactory threadFactory, long sleepTimeNs, GContext gContext) {
		super(parent, threadFactory, true);
		this.sleepTimeNs = sleepTimeNs;
		this.gContext = gContext;
	}

	@Override
	protected void run() {
		do {
			Runnable task = queue.poll();
			// if DB is abnormal, there is no need to execute the task and just discard it.
			if (task != null && gContext.isDBNormal()) {
				task.run();
				this.updateLastExecutionTime();
			} else {
				LockSupport.parkNanos(sleepTimeNs);
			}
		} while (!this.confirmShutdown());

	}

	@Override
	public void execute(Runnable task) {
		super.execute(task);
	}

	@Override
	protected Queue<Runnable> newTaskQueue() {
		queue = new ConcurrentLinkedQueue<>();
		return queue;
	}
}
