/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.runtime.state.gemini.engine.handler;

import org.apache.flink.runtime.state.gemini.engine.dbms.GContext;

import org.apache.flink.shaded.netty4.io.netty.util.concurrent.EventExecutor;
import org.apache.flink.shaded.netty4.io.netty.util.concurrent.MultithreadEventExecutorGroup;

import java.util.concurrent.ThreadFactory;

/**
 * GeminiEventExecutorGroup.
 */
public class GeminiEventExecutorGroup extends MultithreadEventExecutorGroup {

	private final GContext gContext;

	public GeminiEventExecutorGroup(int nThreads, GContext gContext) {
		this(nThreads, (ThreadFactory) null, 1000000, gContext);
	}

	public GeminiEventExecutorGroup(int nThreads, ThreadFactory threadFactory, long sleepTimeNs, GContext gContext) {
		super(nThreads, threadFactory, new Object[]{sleepTimeNs, gContext});
		this.gContext = gContext;
	}

	@Override
	protected EventExecutor newChild(ThreadFactory threadFactory, Object... args) throws Exception {
		return new GeminiEventExecutor(this, threadFactory, (long) args[0], (GContext) args[1]);
	}
}
