/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.runtime.state.gemini.engine.handler;

import org.apache.flink.runtime.state.gemini.engine.page.DataPage;
import org.apache.flink.runtime.state.gemini.engine.page.LogicChainedPage;
import org.apache.flink.runtime.state.gemini.engine.page.PageAddress;

import java.util.List;
import java.util.Map;

/**
 * PageCompactHandler.
 */
public interface PageCompactHandler {
	void doAsyncMajorCompaction(LogicChainedPage logicChainedPage, int pageIndex, int curChainIndex, long version);

	void doAsyncMinorCompaction(
		LogicChainedPage logicChainedPage, int pageIndex, int curChainIndex, long version, boolean force);

	void doSyncReplace(
		LogicChainedPage logicChainedPage,
		int pageIndex,
		int oldCompatedPageSize,
		int oldMemPageSize,
		long oldRequstCount,
		int inclusiveCompactionStartChainIndex,
		int inclusiveCompactionEndChainIndex,
		DataPage compactedDataPage,
		List<PageAddress> invalidPageAddressList,
		int relatedIndex);

	void doAsyncMinorCompactionByRead(
		LogicChainedPage logicPageID,
		int curPageIndex,
		int curChainIndex,
		Map<Integer, DataPage> fetchedDataPageMap);
}
