/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.runtime.state.gemini.engine.hashtable;

import org.apache.flink.runtime.state.gemini.engine.GRegion;
import org.apache.flink.runtime.state.gemini.engine.GTable;
import org.apache.flink.runtime.state.gemini.engine.GTableDescription;
import org.apache.flink.runtime.state.gemini.engine.dbms.GContext;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

/**
 * AbstractGTableKeyedMapImpl.
 * @param <K>
 * @param <MK>
 * @param <MV>
 */
public abstract class AbstractGTableKeyedMapImpl<K, MK, MV> implements GTable<K> {
	protected AbstractGRegionKMapImpl<K, MK, MV, ? extends Map<MK, MV>>[] regions;

	int startGroup;
	int numberGroups;
	int endGroup;
	int maxParallelism;
	GTableDescription description;
	GContext context;

	public AbstractGTableKeyedMapImpl(
		GTableDescription description,
		int startGroup,
		int numberGroups,
		int maxParallelism,
		GContext context) {
		this.startGroup = startGroup;
		this.numberGroups = numberGroups;
		this.endGroup = startGroup + numberGroups;
		this.maxParallelism = maxParallelism;
		this.description = description;
		this.context = context;

		this.regions = new AbstractGRegionKMapImpl[numberGroups];
	}

	@Override
	public GTableDescription getTableDescription() {
		return description;
	}

	@Override
	public Iterator<GRegion> regionIterator() {
		// TODO: remove all the duplicated code.
		return new Iterator<GRegion>() {
			private int currentIndex = 0;

			private void advance() {
				currentIndex++;
				while (currentIndex < regions.length && regions[currentIndex] == null) {
					currentIndex++;
				}
			}

			@Override
			public boolean hasNext() {
				if (currentIndex < regions.length && regions[currentIndex] != null) {
					return true;
				}

				advance();
				return currentIndex < regions.length;
			}

			@Override
			public GRegion next() {
				return regions[currentIndex++];
			}
		};
	}

	@Override
	public Iterator<GRegion> indexRegionIterator() {
		return Collections.emptyIterator();
	}

	@Override
	public GTableDescription getIndexDescription() {
		throw new UnsupportedOperationException("");
	}
}

