/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.runtime.state.gemini.engine.hashtable;

import org.apache.flink.runtime.state.KeyGroupRangeAssignment;
import org.apache.flink.runtime.state.gemini.engine.GRegion;
import org.apache.flink.runtime.state.gemini.engine.GRegionID;
import org.apache.flink.runtime.state.gemini.engine.GRegionIDImpl;
import org.apache.flink.runtime.state.gemini.engine.GTableDescription;
import org.apache.flink.runtime.state.gemini.engine.dbms.GContext;

import java.util.Map;

import static org.apache.flink.util.Preconditions.checkArgument;

/**
 * GTableKeyedMapImpl.
 * @param <K>
 * @param <MK>
 * @param <MV>
 */
public class GTableKeyedMapImpl<K, MK, MV> extends AbstractGTableKeyedMapImpl<K, MK, MV> {
	public GTableKeyedMapImpl(
		GTableDescription description,
		int startGroup,
		int numberGroups,
		int maxParallelism,
		GContext context) {
		super(description, startGroup, numberGroups, maxParallelism, context);
	}

	@SuppressWarnings("unchecked")
	@Override
	public AbstractGRegionKMapImpl<K, MK, MV, ? extends Map<MK, MV>> getRegion(K key) {
		int group = KeyGroupRangeAssignment.assignToKeyGroup(key, maxParallelism);
		int offset = group - startGroup;
		AbstractGRegionKMapImpl<K, MK, MV, ? extends Map<MK, MV>> region = regions[offset];

		if (region == null) {
			region = (GRegionKMapImpl<K, MK, MV>) description.createRegion(context,
				this,
				new GRegionIDImpl(GRegionID.G_REGION_DATA, group));
			regions[offset] = region;
		}

		return region;
	}

	@Override
	public void setRegion(int idx, GRegion region) {
		checkArgument(idx >= startGroup && idx < endGroup);
		regions[idx - startGroup] = (GRegionKMapImpl<K, MK, MV>) region;
	}

	@Override
	public void setIndexRegion(int idx, GRegion indexRegion) {
		throw new UnsupportedOperationException("");
	}
}

