/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.runtime.state.gemini.engine.memstore;

import org.apache.flink.runtime.state.gemini.engine.page.GValueType;

import java.util.HashMap;
import java.util.Map;

/**
 * GSValueMap.
 */
public class GSValueMap<MK, MV> extends GSValue<Map<MK, GSValue<MV>>> {

	public GSValueMap(
		Map<MK, GSValue<MV>> value, GValueType valueType, long seqID) {
		super(value, valueType, seqID);
	}

	@Override
	public Map<MK, GSValue<MV>> getValue() {
		return value;
	}

	public void setSeqID(long seqID) {
		this.seqID = seqID;
	}

	public static <MK, MV> GSValueMap<MK, MV> of(Map<MK, GSValue<MV>> value, GValueType valueType, long seqID) {
		return new GSValueMap<>(value, valueType, seqID);
	}

	public GSValueMap<MK, MV> copyGSValueMap() {
		//only for estimated, so ignore Map's type.
		Map<MK, GSValue<MV>> copyMap = this.value == null ? new HashMap<>() : new HashMap<>(this.value);
		return new GSValueMap<>(new HashMap<>(copyMap), this.getValueType(), this.getSeqID());
	}
}
