/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.runtime.state.gemini.engine.memstore;

import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.state.gemini.engine.page.GValueType;

/**
 * GSValueMapEntry.
 */
public class GSValueMapEntry<MK, MV> extends GSValue<Tuple2<MK, GSValue<MV>>> {

	public GSValueMapEntry(
		Tuple2<MK, GSValue<MV>> entry, GValueType valueType, long seqID) {
		super(entry, valueType, seqID);
	}

	public GSValueMapEntry(
		MK key, GSValue<MV> value, GValueType mapType, long seqID) {
		super(Tuple2.of(key, value), mapType, seqID);
	}

	public GSValueMapEntry(
		MK key, MV value, GValueType mapType, GValueType valueType, long seqID) {
		super(Tuple2.of(key, new GSValue<>(value, valueType, seqID)), mapType, seqID);
	}

	public MK getEntryKey() {
		return getValue().f0;
	}

	public GSValue<MV> getEntryValue() {
		return getValue().f1;
	}

}
