/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.runtime.state.gemini.engine.memstore;

import org.apache.flink.runtime.state.gemini.engine.dbms.Executor;
import org.apache.flink.runtime.state.gemini.engine.page.GValueType;
import org.apache.flink.runtime.state.gemini.engine.snapshot.SnapshotOperation;

import java.util.Map;
import java.util.Set;

/**
 * writeBuffer.
 */
public interface WriteBuffer<K, V> extends Executor {
	void put(K key, V value);

	GSValue<V> get(K key);

	/**
	 * Get all key-value pairs and store them in the given container if it does not exist.
	 */
	void getAll(Map<K, GSValue<V>> container);

	/**
	 * get all keys in writeBuffer, including deleted keys.
	 */
	void allKeysIncludeDeleted(Set<K> container);

	void removeKey(K key);

	GValueType contains(K key);

	void reset();

	void doSnapshot(SnapshotOperation snapshotOperation);
}
