/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.runtime.state.gemini.engine.memstore;

import org.apache.flink.runtime.state.gemini.engine.GRegion;
import org.apache.flink.runtime.state.gemini.engine.page.PageStore;

import org.apache.flink.shaded.netty4.io.netty.util.concurrent.EventExecutor;

import java.util.HashMap;
import java.util.Map;

/**
 * writeBuffer.
 */
public class WriteBufferKMapHashImpl<K, MK, MV> extends AbstractWriteBufferKMapHashImpl<K, MK, MV> {

	public WriteBufferKMapHashImpl(
		GRegion gRegion, EventExecutor eventExecutor, PageStore pageStore) {
		super(gRegion, eventExecutor, pageStore);
		initActive();
	}

	@Override
	protected void initActive() {
		this.active = new SegmentKMapImpl<>(segmentID++, gRegionContext, null);
	}

	@Override
	Segment addFlushingSegment() {
		Segment result = active;
		snapshotQueue.add(active);
		gRegionContext.getWriteBufferStats().addFlushingSegmentCount(1);
		active = new SegmentKMapImpl<>(segmentID++, gRegionContext, null);
		return result;
	}

	@Override
	public Map<MK, GSValue<MV>> createPOJOMap() {
		return new HashMap<>();
	}
}
